<?php
/**
 * The Template for displaying all single posts.
 *
 * @package WordPress
 * @subpackage Spartan WPExplorer Theme
 * @since Spartan 1.0
 */

get_header();

// Get social share wpex_social_share_position
$wpex_social_share_position = get_theme_mod( 'wpex_social_share_position', 'post_bottom' ); ?>

<?php while ( have_posts() ) : the_post(); ?>
	<div id="primary" class="content-area clr">
		<div id="content" class="site-content left-content clr" role="main">
			<article class="single-post-article clr">
				<?php
				// Post before ad
				wpex_ad_spot( 'post-before' ); ?>
				<div class="single-post-media clr">
					<?php
					// Get post format media - image, video. audio, etc
					get_template_part( 'content', get_post_format() ); ?>
				</div><!-- .single-post-media -->
				<header class="post-header clr">
					<h1 class="post-header-title"><?php the_title(); ?></h1>
					<?php
					// Display post meta
					// See functions/commons.php
					wpex_post_meta();
					// Social Sharing Links
					// See functions/social-share.php
					if( get_theme_mod( 'wpex_social_sharing_post_top' ) ) {
						wpex_social_share();
					} ?>
				</header><!-- .page-header -->
				<div class="entry clr">
					<?php
					// Post top ad
					wpex_ad_spot( 'post-top' );
					// Post Content
					the_content();
					// Paginate posts when using <!--nextpage-->
					wp_link_pages( array(
						'before'		=> '<div class="page-links clr">',
						'after'			=> '</div>',
						'link_before'	=> '<span>',
						'link_after' 	=> '</span>',
					) );
					// Post bottom ad
					wpex_ad_spot( 'post-bottom' );
					// Post Tags
					if ( '1' == get_theme_mod( 'wpex_post_tags', '1' ) ) {
						the_tags('<div class="post-tags"><span class="strong">'. __( 'Tags', 'wpex' ).':</span> ', ', ', '</div>');
					} ?>
				</div><!-- .entry -->
			</article>
			<?php
			// Social Sharing Links
			// See functions/social-share.php
			if( get_theme_mod( 'wpex_social_sharing_post_bottom', '1' ) ) {
				wpex_social_share();
			}
			// Author Bio
			if ( get_theme_mod( 'wpex_post_author', '1' ) && 'on' != get_post_meta( get_the_ID(), 'wpex_disable_author', true ) ) {
				get_template_part( 'author', 'bio' );
			}
			// Next/Previous Posts
			wpex_next_prev(); 
			// Related Posts
			if ( get_theme_mod( 'wpex_related', '1' ) && 'on' != get_post_meta( get_the_ID(), 'wpex_disable_related', true ) ) {
				wpex_related_posts();
			}
			// Comments
			comments_template();
			// Edit post link
			if ( is_user_logged_in() && current_user_can( 'edit_post', get_the_ID() ) ) { ?>
				<footer class="entry-footer">
					<?php edit_post_link( __( 'Edit this post', 'wpex' ) .' &#8594;', '<span class="edit-link clr">', '</span>' ); ?>
				</footer><!-- .entry-footer -->
			<?php } ?>
		</div><!-- #content -->
		<?php get_sidebar(); ?>
	</div><!-- #primary -->
<?php endwhile; ?>
<?php get_footer(); ?>