<?php
/**
 * The Header for our theme.
 *
 * @package WordPress
 * @subpackage Spartan WPExplorer Theme
 * @since Spartan 1.0
 */
?><!DOCTYPE html>
<html <?php language_attributes(); ?>>
<head>
	<meta charset="<?php bloginfo( 'charset' ); ?>">
	<?php
	// Responsive Meta Tag
	if ( get_theme_mod( 'wpex_responsive', '1' ) ) { ?>
		<meta name="viewport" content="width=device-width, initial-scale=1">
	<?php }
	// Non Responsive Meta tag
	else { ?>
		<meta name="viewport" content="initial-scale=1, maximum-scale=1, user-scalable=no">
	<?php } ?>
	<?php // Yoast SEO
	if ( function_exists( 'wpseo_auto_load' ) ) { ?>
		<title><?php wp_title(); ?></title>
	<?php } else { ?>
		<title><?php wp_title( '|', true, 'right' ); ?><?php bloginfo('name'); ?></title>
	<?php } ?>
	<link rel="pingback" href="<?php bloginfo( 'pingback_url' ); ?>">
	<!--[if lt IE 9]>
		<script src="<?php echo get_template_directory_uri(); ?>/js/html5.js" type="text/javascript"></script>
	<![endif]-->
	<?php wp_head(); ?>

<!-- Global site tag (gtag.js) - Google Analytics -->
<!-- Google tag (gtag.js) -->
<script async src="https://www.googletagmanager.com/gtag/js?id=G-3Q5HKE0MBE"></script>
<script>
  window.dataLayer = window.dataLayer || [];
  function gtag(){dataLayer.push(arguments);}
  gtag('js', new Date());

  gtag('config', 'G-3Q5HKE0MBE');
</script>

</head>

<body <?php body_class(); ?>>

	<div id="wrap" class="clr">

		<div id="top-wrap" class="clr">
			<?php
			// Display topbar if enabled
			if( get_theme_mod( 'wpex_topbar', '1' ) ) { ?>
				<div id="topbar" class="clr">
					<div class="container clr">
						<?php
						// Display topbar date if enabled
						if( get_theme_mod( 'wpex_topbar_date', '1' ) ) { ?>
						<div id="topbar-date" class="clr">
							<div class="topbar-date-full"><span class="fa fa-clock-o"></span><?php echo date('l jS F Y'); ?></div>
							<div class="topbar-date-condensed"><span class="fa fa-clock-o"></span><?php echo date('j-M-Y'); ?></div>
						</div><!-- .topbar-date -->
						<?php }
						// Display top_menu nav region if menu is defined in this area
						if ( has_nav_menu( 'top_menu' ) ) { ?>
							<div id="topbar-nav" class="cr">
								<?php wp_nav_menu( array(
									'theme_location'	=> 'top_menu',
									'sort_column'		=> 'menu_order',
									'menu_class'		=> 'top-nav sf-menu',
									'fallback_cb'		=> false,
									'walker'			=> new WPEX_Top_Walker_Nav_Menu(),
								) ); ?>
							</div><!-- #topbar-nav -->
						<?php
						}
						// Display topbar search if enabled
						if( get_theme_mod( 'wpex_topbar_search', '1' ) ) { ?>
							<div id="topbar-search" class="clr">
								<form method="get" class="topbar-searchform" action="<?php echo esc_url( home_url( '/' ) ); ?>" role="search">
									<input type="search" class="field topbar-searchform-input" name="s" value="<?php echo esc_attr( get_search_query() ); ?>" placeholder="<?php _e( 'Type your search & hit enter','wpex' ); ?>" />
									<button type="submit" class="topbar-searchform-btn"><span class="fa fa-search"></span></button>
								</form>
							</div><!-- topbar-search -->
							<?php
							// Search toggle for mobile devices
							if ( get_theme_mod( 'wpex_responsive', '1' ) ) { ?>
								<span class="fa fa-search topbar-search-mobile-toggle"></span>
							<?php } ?>
						<?php } ?>
						<?php
						// Login link
						$wpex_login_page = get_theme_mod( 'wpex_login_page' );
						if ( $wpex_login_page && get_theme_mod( 'wpex_responsive', '1' ) ) { ?>
							<a href="<?php echo get_permalink( $wpex_login_page ); ?>" title="<?php echo get_the_title( $wpex_login_page ); ?> "><span class="fa fa-user topbar-mobile-login-link"></span></a>
						<?php } ?>
						<?php
						// Top nav mobile toggle
						if ( has_nav_menu( 'top_menu' ) && get_theme_mod( 'wpex_responsive', '1' ) ) { ?>
							<span class="fa fa-bars topbar-nav-mobile-toggle"></span>
						<?php } ?>
					</div><!-- .container -->
				</div><!-- #topbar -->
			<?php } ?>
			<header id="header" class="site-header clr container" role="banner">
				<div class="site-branding clr">
					<?php
					// Outputs the site logo
					// See functions/logo.php
					wpex_logo();
					// Site description
					$wpex_site_description = get_theme_mod( 'wpex_logo_subheading', __( 'Edit your subheading via the theme customizer.', 'wpex' ) );
					if ( $wpex_site_description ) { ?>
						<div id="blog-description" class="clr">
							<?php echo $wpex_site_description; ?>
						</div><!-- #blog-description -->
					<?php } ?>
				</div><!-- .site-branding -->
				<?php echo wpex_ad_spot( 'header' ); ?>
			</header><!-- #header -->
			<div id="site-navigation-wrap" class="clr">
				<div id="site-navigation-inner" class="clr container">
					<nav id="site-navigation" class="navigation main-navigation clr" role="navigation">
						<?php
						// Check if main menu if defined
						if ( has_nav_menu( 'main_menu' ) ) {
							// Display main nav
							wp_nav_menu( array(
								'theme_location'	=> 'main_menu',
								'sort_column'		=> 'menu_order',
								'menu_class'		=> 'main-nav dropdown-menu sf-menu',
								'fallback_cb'		=> false,
							) );
						// Display nav toggle for mobile devices
						if ( get_theme_mod( 'wpex_responsive', '1' ) ) { ?>
							<a href="#mobile-nav" class="navigation-toggle"><span class="fa fa-bars navigation-toggle-icon"></span><span class="navigation-toggle-text"><?php echo get_theme_mod( 'wpex_mobile_menu_open_text', __( 'Click here to navigate', 'wpex' ) ); ?></span></a>
						<?php } ?>
						<?php }
						// If main menu isn't defined display notice
						elseif ( is_user_logged_in() && current_user_can( 'edit_theme_options' ) ) { ?>
							<div id="site-navigation-notice">
								<?php echo '<a href="'. admin_url( 'nav-menus.php' ) .'" title="'. __( 'WordPress Menu Editor', 'wpex' ) .'">'. __( 'Create and assign your menu', 'wpex' ) .' &rarr;</a>'; ?>
							</div>
						<?php } ?>
					</nav><!-- #site-navigation -->
				</div><!-- #site-navigation-inner -->
			</div><!-- #site-navigation-wrap -->
		</div><!-- #top-wrap -->

		<div class="site-main-wrap clr">
			<div id="main" class="site-main clr container">