<?php
/**
 * Tabs Widget
 *
 * @package WordPress
 * @subpackage Spartan WPExplorer Theme
 * @since Spartan 1.0
*/

if( ! class_exists( 'wpex_tabs_widget' ) ) :
	class wpex_tabs_widget extends WP_Widget {
		
		/** constructor */
		function wpex_tabs_widget() {
			parent::WP_Widget(false, $name = WPEX_THEME_BRANDING . ' - '. __('Tabs','wpex' ), array( 'description' => __( 'Popular Posts, Recent Posts & Recent Comments.', 'wpex' ) ) );
		}

		/** @see WP_Widget::widget */
		function widget($args, $instance) {
			extract( $args );
			$title = $instance['title'];
			$popular_number = isset( $instance['popular_number'] ) ? $instance['popular_number'] : '';
			$recent_number = isset( $instance['recent_number'] ) ? $instance['recent_number'] : '';
			$comments_number = isset( $instance['comments_number'] ) ? $instance['comments_number'] : '';
			$img_height = isset( $instance['img_height'] ) ? $instance['img_height'] : '9999';
			$img_width = isset( $instance['img_width'] ) ? $instance['img_width'] : '9999';
			$img_height = ( '' != $img_height ) ? $img_height : '9999';
			$img_width = ( '' != $img_width ) ? $img_width : '9999';
			if ( is_singular() ) {
				$exclude = array( get_the_ID() );
			} else {
				$exclude = NULL;
			}
			echo $before_widget;
				if ( $title )
						echo $before_title . $title . $after_title;
						global $post; ?>
							<div class="wpex-tabs-widget clr">
								<div class="wpex-tabs-widget-inner clr">
									<div class="wpex-tabs-widget-tabs clr">
										<ul>
											<?php if( '0' != $popular_number ) { ?>
												<li><a href="#" data-tab="#wpex-widget-popular-tab" class="active"><?php _e( 'Popular', 'wpex' ); ?></a></li>
											<?php }
											if( '0' != $recent_number ) { ?>
												<li><a href="#" data-tab="#wpex-widget-recent-tab" <?php if( '0' == $popular_number ) echo 'class="active"'; ?>><?php _e( 'Recent', 'wpex' ); ?></a></li>
											<?php }
											if( '0' != $comments_number ) { ?>
											<li><a href="#" data-tab="#wpex-widget-comments-tab" class="last"><?php _e( 'Comments', 'wpex' ); ?></a></li>
											<?php } ?>
										</ul>
									</div><!-- .wpex-tabs-widget-tabs -->
									<?php
									// Popular Tab
									if( '0' != $popular_number ) {
										// Query Posts
										$wpex_query = new WP_Query( array(
											'post_type'				=> 'post',
											'posts_per_page'		=> $popular_number,
											'orderby'				=> 'comment_count',
											'no_found_rows'			=> true,
											'post__not_in'			=> $exclude,
											'ignore_sticky_posts'	=> true,
										) );
										if ( $wpex_query->have_posts() ) { ?>
											<div id="wpex-widget-popular-tab" class="wpex-tabs-widget-tab active-tab clr">
												<ul class="clr">
													<?php
													$count = '';
													foreach( $wpex_query->posts as $post ) : setup_postdata( $post );
														$count++;
														// Image
														$image = wpex_img_resize( wp_get_attachment_url( get_post_thumbnail_id() ), $img_width, $img_height, true, 'array' ); ?>
														<li class="clr">
															<a href="<?php the_permalink(); ?>" title="<?php the_title(); ?>" class="clr">
																<span class="counter"><?php echo $count; ?></span>
																<span class="title strong"><?php the_title(); ?>:</span> <?php echo wp_trim_words( get_the_content(), '10', '&hellip;' ); ?>
															</a>
														</li>
													<?php endforeach; wp_reset_postdata(); ?>
												</ul>
											</div><!-- wpex-tabs-widget-tab -->
										<?php }
									}
									// Recent tab
									if( '0' != $recent_number ) {
										// Query Posts
										$wpex_query = new WP_Query( array(
											'post_type'				=> 'post',
											'posts_per_page'		=> $recent_number,
											'orderby'				=> 'date',
											'no_found_rows'			=> true,
											'post__not_in'			=> $exclude,
											'ignore_sticky_posts'	=> true,
											'meta_key'				=> '_thumbnail_id',
										) );
										if ( $wpex_query->have_posts() ) { ?>
											<div id="wpex-widget-recent-tab" class="wpex-tabs-widget-tab <?php if( '0' == $popular_number ) echo 'active-tab'; ?> clr">
												<ul class="clr">
													<?php
													// Loop through Posts
													foreach( $wpex_query->posts as $post ) : setup_postdata( $post );
														// Image
														$image = wpex_img_resize( wp_get_attachment_url( get_post_thumbnail_id() ), $img_width, $img_height, true, 'array' ); ?>
														<li class="clr">
															<a href="<?php the_permalink(); ?>" title="<?php the_title(); ?>" class="clr">
																<img src="<?php echo $image['url']; ?>" alt="<?php the_title(); ?>" width="<?php echo $image['width']; ?>" height="<?php echo $image['height']; ?>" />
																<span class="title strong"><?php the_title(); ?>:</span> <?php echo wp_trim_words( get_the_content(), '10', '&hellip;' ); ?>
															</a>
														</li>
													<?php endforeach; wp_reset_postdata(); ?>
												</ul>
											</div><!-- wpex-tabs-widget-tab -->
									<?php }
									}
									// Comments tab
									if( '0' != $comments_number ) { ?>
									<div id="wpex-widget-comments-tab" class="wpex-tabs-widget-tab clr">
										<ul class="clr">
											<?php
											// Query Posts
											$comments = get_comments( array (
												'number'		=> $comments_number,
												'status'		=> 'approve',
												'post_status'	=> 'publish',
												'type'			=> 'comment'
											) );
											if ( $comments ) {
												foreach ( $comments as $comment ) {
													$comment_excerpt = wp_trim_words( $comment->comment_content, '10' );
													if( $comment_excerpt ) { ?>
														<li class="clr">
															<a href="<?php echo get_permalink( $comment->comment_post_ID ) . '#comment-' . $comment->comment_ID; ?>" title="<?php the_title(); ?>" class="clr">
																<?php echo get_avatar( $comment->comment_author_email, $img_width ); ?>
																<span class="title strong"><?php echo get_comment_author( $comment->comment_ID ); ?>:</span> <?php echo $comment_excerpt; ?>&hellip;
															</a>
														</li>
													<?php } ?>
												<?php }
											} else { ?>
												<li><?php _e( 'No comments yet.', 'wpex' ); ?></li>
											<?php } ?>
										</ul>
									</div><!-- .wpex-tabs-widget-tab -->
									<?php } ?>
								</div><!-- .wpex-tabs-widget-inner -->
							</div><!-- .wpex-tabs-widget -->
			<?php echo $after_widget;
		}

		/** @see WP_Widget::update */
		function update( $new_instance, $old_instance ) {
			$instance = $old_instance;
			$instance['title'] = strip_tags( $new_instance['title'] );
			$instance['popular_number'] = strip_tags( $new_instance['popular_number'] );
			$instance['recent_number'] = strip_tags( $new_instance['recent_number'] );
			$instance['comments_number'] = strip_tags( $new_instance['comments_number'] );
			$instance['order'] = strip_tags( $new_instance['order'] );
			$instance['img_height'] = strip_tags( $new_instance['img_height'] );
			$instance['img_width'] = strip_tags( $new_instance['img_width'] );
			return $instance;
		}

		/** @see WP_Widget::form */
		function form( $instance ) {
			$instance = wp_parse_args( ( array ) $instance, array(
				'title'				=> '',
				'popular_number'	=> '5',
				'recent_number'		=> '3',
				'comments_number'	=> '3',
				'order'				=> 'ASC',
				'img_height'		=> '50',
				'img_width'			=> '50',
			) );
			$title = esc_attr( $instance[ 'title' ] );
			$popular_number = esc_attr( $instance[ 'popular_number' ] );
			$recent_number = esc_attr( $instance[ 'recent_number' ] );
			$comments_number = esc_attr( $instance[ 'comments_number' ] );
			$img_height = esc_attr( $instance[ 'img_height' ] );
			$img_width = esc_attr( $instance[ 'img_width' ] ); ?>
			
			
			<p>
				<label for="<?php echo $this->get_field_id('title'); ?>"><?php _e( 'Title:', 'wpex' ); ?></label> 
				<input class="widefat" id="<?php echo $this->get_field_id('title'); ?>" name="<?php echo $this->get_field_name('title','wpex' ); ?>" type="text" value="<?php echo $title; ?>" />
			</p>
			<p>
				<label for="<?php echo $this->get_field_id( 'popular_number' ); ?>"><?php _e( 'Popular: Number To Show:', 'wpex' ); ?></label> 
				<input class="widefat" id="<?php echo $this->get_field_id( 'popular_number' ); ?>" name="<?php echo $this->get_field_name( 'popular_number' ); ?>" type="text" value="<?php echo $popular_number; ?>" />
			</p>
			<p>
				<label for="<?php echo $this->get_field_id( 'recent_number' ); ?>"><?php _e( 'Recent: Number To Show:', 'wpex' ); ?></label> 
				<input class="widefat" id="<?php echo $this->get_field_id( 'recent_number' ); ?>" name="<?php echo $this->get_field_name( 'recent_number' ); ?>" type="text" value="<?php echo $recent_number; ?>" />
			</p>
			<p>
				<label for="<?php echo $this->get_field_id( 'comments_number' ); ?>"><?php _e( 'Comments: Number To Show:', 'wpex' ); ?></label> 
				<input class="widefat" id="<?php echo $this->get_field_id( 'comments_number' ); ?>" name="<?php echo $this->get_field_name( 'comments_number' ); ?>" type="text" value="<?php echo $comments_number; ?>" />
			</p>
			<p>
				<label for="<?php echo $this->get_field_id('img_height'); ?>"><?php _e( 'Image Crop Height:', 'wpex' ); ?></label> 
				<input class="widefat" id="<?php echo $this->get_field_id('img_height'); ?>" name="<?php echo $this->get_field_name('img_height'); ?>" type="text" value="<?php echo $img_height; ?>" />
			</p>
			<p>
				<label for="<?php echo $this->get_field_id('img_width'); ?>"><?php _e( 'Image Crop Width:', 'wpex' ); ?></label> 
				<input class="widefat" id="<?php echo $this->get_field_id('img_width'); ?>" name="<?php echo $this->get_field_name('img_width'); ?>" type="text" value="<?php echo $img_width; ?>" />
			</p>

			<?php
		}
	}
endif;
add_action('widgets_init', create_function( '', 'return register_widget( "wpex_tabs_widget" );' ) ); ?>