<?php
/**
 * Recent Posts w/ Thumbnails
 *
 * @package WordPress
 * @subpackage Spartan WPExplorer Theme
 * @since Spartan 1.0
*/

if( ! class_exists( 'wpex_recent_posts_thumb_widget' ) ) :
	class wpex_recent_posts_thumb_widget extends WP_Widget {
		
		/** constructor */
		function wpex_recent_posts_thumb_widget() {
			parent::WP_Widget(
				false,
				$name = WPEX_THEME_BRANDING . ' - '. __( 'Posts With Thumbnails', 'wpex' ),
				array(
					'description'	=> __( 'Recent posts with thumbnails.', 'wpex' )
				)
			);
		}

		/** @see WP_Widget::widget */
		function widget($args, $instance) {

			// Get widget vars
			extract( $args );
			$title = $instance['title'];
			$number = isset( $instance['number'] ) ? $instance['number'] : '3';
			$order = isset( $instance['order'] ) ? $instance['order'] : 'DESC';
			$orderby = isset( $instance['orderby'] ) ? $instance['orderby'] : 'date';
			$style = isset( $instance['style'] ) ? $instance['style'] : 'left-thumbnail';
			$date = isset( $instance['date'] ) ? $instance['date'] : '';
			$img_height = isset( $instance['img_height'] ) ? $instance['img_height'] : '90';
			$img_width = isset( $instance['img_width'] ) ? $instance['img_width'] : '140';
			$img_height = ( '' != $img_height ) ? $img_height : '9999';
			$img_width = ( '' != $img_width ) ? $img_width : '9999';
			$category = isset( $instance['category'] ) ? $instance['category'] : 'all';
			$format = isset( $instance['format'] ) ? $instance['format'] : 'all';

			// Exclude current post
			if ( is_singular() ) {
				$exclude = array( get_the_ID() );
			} else {
				$exclude = NULL;
			}
				echo $before_widget;
					// Output title
					if ( $title ) {
						// Title
						echo $before_title . $title . $after_title;
					}
					// Create Category tax_query
					if ( !empty( $category ) && 'all' != $category ) {
						$taxonomy = array (
							'taxonomy'	=> 'category',
							'field'		=> 'id',
							'terms'		=> $category,
						);
					} else {
						$taxonomy = NUll;
					}
					// Create format tax_query
					if( $format && 'all' != $format ) {
						$format_query = array (
							'taxonomy'	=> 'post_format',
							'field'		=> 'slug',
							'terms'		=> array( 'post-format-'. $format ),
						);
					} else {
						$format_query = NULL;
					}
					// Query Posts
					global $post;
					$wpex_query = new WP_Query( array(
						'post_type'				=> 'post',
						'posts_per_page'		=> $number,
						'orderby'				=> $orderby,
						'order'					=> $order,
						'no_found_rows'			=> true,
						'meta_key'				=> '_thumbnail_id',
						'post__not_in'			=> $exclude,
						'tax_query'				=> array(
							'relation' => 'AND',
							$taxonomy,
							$format_query,
						),
						'ignore_sticky_posts'	=> true
					) );
					// Loop through posts
					if ( $wpex_query->have_posts() ) { ?>
						<ul class="widget-recent-posts clr">
							<?php foreach( $wpex_query->posts as $post ) : setup_postdata( $post );
								// Image
								$image = wpex_img_resize( wp_get_attachment_url( get_post_thumbnail_id() ), $img_width, $img_height, true, 'array' ); ?>
								<li class="clr widget-recent-posts-li <?php echo $style; ?> format-<?php echo get_post_format(); ?>">
									<a href="<?php the_permalink(); ?>" title="<?php the_title(); ?>" class="widget-recent-posts-thumbnail clr">
										<img src="<?php echo $image['url']; ?>" alt="<?php the_title(); ?>" width="<?php echo $image['width']; ?>" height="<?php echo $image['height']; ?>" />
									</a>
									<div class="widget-recent-posts-content clr">
										<a href="<?php the_permalink(); ?>" title="<?php the_title(); ?>" class="widget-recent-posts-title"><?php the_title(); ?></a>
										<?php if ( $date !== '1' ) { ?>
											<div class="widget-recent-posts-date"><?php echo get_the_date(); ?></div>
										<?php } ?>
										</div><!-- .widget-recent-posts-content -->
								</li>
							<?php endforeach; ?>
						</ul>
					<?php }
				// Reset post data
				wp_reset_postdata();
			// After widget hook
			echo $after_widget;
		}

		/** @see WP_Widget::update */
		function update( $new_instance, $old_instance ) {
			$instance = $old_instance;
			$instance['title'] = strip_tags( $new_instance['title'] );
			$instance['number'] = strip_tags( $new_instance['number'] );
			$instance['style'] = strip_tags( $new_instance['style'] );
			$instance['order'] = strip_tags( $new_instance['order'] );
			$instance['orderby'] = strip_tags( $new_instance['orderby'] );
			$instance['date'] = strip_tags( $new_instance['date'] );
			$instance['category'] = strip_tags( $new_instance['category'] );
			$instance['format'] = strip_tags( $new_instance['format'] );
			$instance['img_height'] = strip_tags( $new_instance['img_height'] );
			$instance['img_width'] = strip_tags( $new_instance['img_width'] );
			return $instance;
		}

		/** @see WP_Widget::form */
		function form( $instance ) {	

			// Setup instance vars
			$instance = wp_parse_args( (array) $instance, array(
				'title'			=> __('Recent Posts','wpex'),
				'style'			=> 'left-thumbnail',
				'number'		=> '3',
				'order'			=> 'DESC',
				'orderby'		=> 'date',
				'date'			=> '',
				'img_height'	=> '90',
				'img_width'		=> '140',
				'category'		=> 'all',
				'format'		=> 'all',

			) );

			// Get values
			$title = esc_attr( $instance['title'] );
			$number = esc_attr( $instance['number'] );
			$order = esc_attr( $instance['order'] );
			$orderby = esc_attr( $instance['orderby'] );
			$style = esc_attr( $instance['style'] );
			$category = esc_attr( $instance['category'] );
			$format  = esc_attr( $instance['format'] );
			$date = esc_attr( $instance['date'] );
			$img_height = esc_attr( $instance['img_height'] );
			$img_width = esc_attr( $instance['img_width'] ); ?>
			
			
			<p>
				<label for="<?php echo $this->get_field_id('title'); ?>"><?php _e('Title', 'wpex'); ?>:</label> 
				<input class="widefat" id="<?php echo $this->get_field_id('title'); ?>" name="<?php echo $this->get_field_name('title','wpex'); ?>" type="text" value="<?php echo $title; ?>" />
			</p>

			<p>
				<label for="<?php echo $this->get_field_id('number'); ?>"><?php _e('Number to Show', 'wpex'); ?>:</label> 
				<input class="widefat" id="<?php echo $this->get_field_id('number'); ?>" name="<?php echo $this->get_field_name('number'); ?>" type="text" value="<?php echo $number; ?>" />
			</p>

			<p>
				<label for="<?php echo $this->get_field_id('img_width'); ?>"><?php _e('Image Crop Width', 'wpex'); ?>:</label>
				<input class="widefat" id="<?php echo $this->get_field_id('img_width'); ?>" name="<?php echo $this->get_field_name('img_width'); ?>" type="text" value="<?php echo $img_width; ?>" />
			</p>

			<p>
				<label for="<?php echo $this->get_field_id('img_height'); ?>"><?php _e('Image Crop Height', 'wpex'); ?>:</label> 
				<input class="widefat" id="<?php echo $this->get_field_id('img_height'); ?>" name="<?php echo $this->get_field_name('img_height'); ?>" type="text" value="<?php echo $img_height; ?>" />
			</p>

			<p>
				<label for="<?php echo $this->get_field_id('style'); ?>"><?php _e('Style', 'wpex'); ?>:</label>
				<br />
				<select class='wpex-select' name="<?php echo $this->get_field_name('style'); ?>" id="<?php echo $this->get_field_id('style'); ?>">
				<option value="left-thumbnail" <?php if($style == 'left-thumbnail') { ?>selected="selected"<?php } ?>><?php _e('Left Thumbnail', 'wpex'); ?></option>
				<option value="top-thumbnail" <?php if($style == 'top-thumbnail') { ?>selected="selected"<?php } ?>><?php _e('Top Thumbnail', 'wpex'); ?></option>
				</select>
			</p>

			<p>
				<label for="<?php echo $this->get_field_id('order'); ?>"><?php _e('Order', 'wpex'); ?>:</label>
				<br />
				<select class='wpex-select' name="<?php echo $this->get_field_name('order'); ?>" id="<?php echo $this->get_field_id('order'); ?>">
				<option value="DESC" <?php if( $order == 'DESC' ) { ?>selected="selected"<?php } ?>><?php _e( 'Descending', 'wpex' ); ?></option>
				<option value="ASC" <?php if( $order == 'ASC' ) { ?>selected="selected"<?php } ?>><?php _e( 'Ascending', 'wpex' ); ?></option>
				</select>
			</p>

			<p>
				<label for="<?php echo $this->get_field_id('orderby'); ?>"><?php _e('Order By', 'wpex'); ?>:</label>
				<br />
				<select class='wpex-select' name="<?php echo $this->get_field_name('orderby'); ?>" id="<?php echo $this->get_field_id('orderby'); ?>">
				<?php $orderby_array = array (
					'date'			=> __( 'Date', 'wpex' ),
					'title'			=> __( 'Title', 'wpex' ),
					'modified'		=> __( 'Modified', 'wpex' ),
					'author'		=> __( 'Author', 'wpex' ),
					'rand'			=> __( 'Random', 'wpex' ),
					'comment_count'	=> __( 'Comment Count', 'wpex' ),
				);
				foreach ( $orderby_array as $key => $value ) { ?>
					<option value="<?php echo $key; ?>" <?php if( $orderby == $key ) { ?>selected="selected"<?php } ?>>
						<?php echo $value; ?>
					</option>
				<?php } ?>
				</select>
			</p>

			<p>
				<label for="<?php echo $this->get_field_id( 'category' ); ?>"><?php _e( 'Category', 'wpex' ); ?>:</label>
				<br />
				<select class='wpex-select' name="<?php echo $this->get_field_name('category'); ?>" id="<?php echo $this->get_field_id('category'); ?>">
				<option value="all" <?php if($category == 'all') { ?>selected="selected"<?php } ?>><?php _e('All', 'wpex'); ?></option>
				<?php $terms = get_terms( 'category' );
				foreach ( $terms as $term ) { ?>
					<option value="<?php echo $term->term_id; ?>" <?php if( $category == $term->term_id ) { ?>selected="selected"<?php } ?>><?php echo $term->name; ?></option>
				<?php } ?>
				</select>
			</p>

			<p>
				<label for="<?php echo $this->get_field_id( 'format' ); ?>"><?php _e( 'Format', 'wpex' ); ?>:</label>
				<br />
				<select class='wpex-select' name="<?php echo $this->get_field_name( 'format' ); ?>" id="<?php echo $this->get_field_id( 'format' ); ?>">
				<option value="all" <?php if( $format == 'all' ) { ?>selected="selected"<?php } ?>><?php _e( 'All', 'wpex' ); ?></option>
				<?php $terms = array( 'video', 'audio', 'gallery' );
				foreach ( $terms as $term ) { ?>
					<option value="<?php echo $term; ?>" <?php if( $format == $term ) { ?>selected="selected"<?php } ?>><?php echo $term; ?></option>
				<?php } ?>
				</select>
			</p>

			<p>
				<input id="<?php echo $this->get_field_id('date'); ?>" name="<?php echo $this->get_field_name('date'); ?>" type="checkbox" value="1" <?php checked( '1', $date ); ?> />
				<label for="<?php echo $this->get_field_id('date'); ?>"><?php _e('Disable Date?', 'wpex'); ?></label>
			</p>

			<?php
		}
	}
endif;
add_action( 'widgets_init', create_function( '', 'return register_widget("wpex_recent_posts_thumb_widget");' ) ); ?>