<?php
/**
 * Flickr Widget
 *
 * @package WordPress
 * @subpackage Spartan WPExplorer Theme
 * @since Spartan 1.0
*/

if( ! function_exists( 'wpex_flickr_widget' ) ) :
	class wpex_flickr_widget extends WP_Widget {
		
		function wpex_flickr_widget() {
			
			// define widget title and description
			$widget_ops = array(
				'classname'		=> 'flickr_widget',
				'description'	=> __( 'Pulls in images from your Flickr account.', 'wpex' )
			);
			// register the widget
			$this->WP_Widget( 'wpex_flickr_widget', WPEX_THEME_BRANDING . ' - '. __( 'Flickr Stream', 'wpex' ), $widget_ops);
		
		}
		
		// display the widget in the theme
		function widget( $args, $instance ) {
			extract( $args );
			$title = apply_filters( 'widget_title', $instance['title'] );
			$number = (int) strip_tags( $instance['number'] );
			$id = strip_tags( $instance['id'] );
			echo $before_widget;
				 if ( $title ) {
					 echo $before_title . $title . $after_title;
				 } ?>
				<div class="wpex-flickr-widget">
					<script type="text/javascript" src="http://www.flickr.com/badge_code_v2.gne?count=<?php echo $number; ?>&amp;display=latest&amp;size=s&amp;layout=x&amp;source=user&amp;user=<?php echo $id; ?>"></script>
				</div>
				<?php
			echo $after_widget;
		}
		
		// update the widget when new options have been entered
		function update( $new_instance, $old_instance ) {
			
			$instance = $old_instance;
			$instance['title'] = strip_tags($new_instance['title']);
			$instance['number'] = (int) strip_tags($new_instance['number']);
			$instance['id'] = strip_tags($new_instance['id']);

			return $instance;
		}
		
		// print the widget option form on the widget management screen
		function form( $instance ) {

		// combine provided fields with defaults
		$instance = wp_parse_args( (array) $instance, array(
			'title'		=>'Flickr Feed',
			'id'		=> '',
			'number'	=> 8
		) );
		$id = strip_tags( $instance['id'] );
		$number = strip_tags( $instance['number'] );
		$title = strip_tags( $instance['title'] ); ?>

		<p>
			<label for="<?php echo $this->get_field_id('title'); ?>">
			<?php _e( 'Title:', 'wpex' ); ?></label>
			<input class="widefat" id="<?php echo $this->get_field_id('title'); ?>" name="<?php echo $this->get_field_name('title'); ?>" type="text" value="<?php echo
			esc_attr($title); ?>" />
		</p>
		<p>
			<label for="<?php echo $this->get_field_id('id'); ?>">
			<?php _e( 'Flickr ID ', 'wpex' ); ?>:</label>
			<input class="widefat" id="<?php echo $this->get_field_id('id'); ?>" name="<?php echo $this->get_field_name('id'); ?>" type="text" value="<?php echo
			esc_attr($id); ?>" />
		</p>
		<p>
			<label for="<?php echo $this->get_field_id('number'); ?>">
			<?php _e( 'Number:', 'wpex' ); ?></label>
			<input class="widefat" id="<?php echo $this->get_field_id('number'); ?>" name="<?php echo $this->get_field_name('number'); ?>" type="text" value="<?php echo
			esc_attr($number); ?>" />
		</p>
		<?php
		}
	}
endif;
add_action( 'widgets_init', create_function( '', 'return register_widget("wpex_flickr_widget");' ) );