<?php
/**
 * Define sidebars for use in this theme
 * @package WordPress
 * @subpackage Spartan WPExplorer Theme
 * @since Spartan 1.0
 */

// Vars
$wpex_sidebar_heading_tags = get_theme_mod( 'wpex_sidebar_heading_tags', 'span' );
$wpex_sidebar_heading_tags = $wpex_sidebar_heading_tags ? $wpex_sidebar_heading_tags : 'span';

$wpex_footer_heading_tags = get_theme_mod( 'wpex_footer_heading_tags', 'span' );
$wpex_footer_heading_tags = $wpex_footer_heading_tags ? $wpex_footer_heading_tags : 'span';

// Sidebar
register_sidebar( array(
	'name'			=> __( 'Sidebar', 'wpex' ),
	'id'			=> 'sidebar',
	'description'	=> __( 'Widgets in this area are used in the sidebar region.', 'wpex' ),
	'before_widget'	=> '<div class="sidebar-widget %2$s clr">',
	'after_widget'	=> '</div>',
	'before_title'	=> '<'. $wpex_sidebar_heading_tags.' class="widget-title">',
	'after_title'	=> '</'. $wpex_sidebar_heading_tags.'>',
) );

// Footer 1
register_sidebar( array(
	'name'			=> __( 'Footer 1', 'wpex' ),
	'id'			=> 'footer-one',
	'description'	=> __( 'Widgets in this area are used in the first footer region.', 'wpex' ),
	'before_widget'	=> '<div class="footer-widget %2$s clr">',
	'after_widget'	=> '</div>',
	'before_title'	=> '<'. $wpex_footer_heading_tags.' class="widget-title">',
	'after_title'	=> '</'. $wpex_footer_heading_tags.'>',
) );

// Footer 2
if ( get_theme_mod( 'wpex_footer_columns', '4' ) > '1' ) {
	register_sidebar( array(
		'name'			=> __( 'Footer 2', 'wpex' ),
		'id'			=> 'footer-two',
		'description'	=> __( 'Widgets in this area are used in the second footer region.', 'wpex' ),
		'before_widget'	=> '<div class="footer-widget %2$s clr">',
		'after_widget'	=> '</div>',
		'before_title'	=> '<'. $wpex_footer_heading_tags.' class="widget-title">',
		'after_title'	=> '</'. $wpex_footer_heading_tags.'>',
	) );
}

// Footer 3
if ( get_theme_mod( 'wpex_footer_columns', '4' ) > '2' ) {
	register_sidebar( array(
		'name'			=> __( 'Footer 3', 'wpex' ),
		'id'			=> 'footer-three',
		'description'	=> __( 'Widgets in this area are used in the third footer region.', 'wpex' ),
		'before_widget'	=> '<div class="footer-widget %2$s clr">',
		'after_widget'	=> '</div>',
		'before_title'	=> '<'. $wpex_footer_heading_tags.' class="widget-title">',
		'after_title'	=> '</'. $wpex_footer_heading_tags.'>',
	) );
}

// Footer 4
if ( get_theme_mod( 'wpex_footer_columns', '4' ) > '3' ) {
	register_sidebar( array(
		'name'			=> __( 'Footer 4', 'wpex' ),
		'id'			=> 'footer-four',
		'description'	=> __( 'Widgets in this area are used in the fourth footer region.', 'wpex' ),
		'before_widget'	=> '<div class="footer-widget %2$s clr">',
		'after_widget'	=> '</div>',
		'before_title'	=> '<'. $wpex_footer_heading_tags.' class="widget-title">',
		'after_title'	=> '</'. $wpex_footer_heading_tags.'>',
	) );
}