<?php
/**
 * Custom User profile settings
 * Enables more fields (twitter,facebook,etc)
 *
 * @package WordPress
 * @subpackage Spartan
 * @since Spartan 1.0
 */

if ( !function_exists( 'wpex_add_user_fields' ) ) :
	function wpex_add_user_fields( $contactmethods ) {
	// Add Website
	if ( !isset( $contactmethods['wpex_website'] ) ) {
		$contactmethods['wpex_website'] = WPEX_THEME_BRANDING .' - '. __( 'Website Name', 'wpex' );
	}
	// Add Twitter
	if ( !isset( $contactmethods['wpex_twitter'] ) ) {
		$contactmethods['wpex_twitter'] = WPEX_THEME_BRANDING .' - Twitter';
	}
	// Add Facebook
	if ( !isset( $contactmethods['wpex_facebook'] ) ) {
		$contactmethods['wpex_facebook'] = WPEX_THEME_BRANDING .' - Facebook';
	}
	// Add GoglePlus
	if ( !isset( $contactmethods['wpex_googleplus'] ) ) {
		$contactmethods['wpex_googleplus'] = WPEX_THEME_BRANDING .' - Google+';
	}
	// Add LinkedIn
	if ( !isset( $contactmethods['wpex_linkedin'] ) ) {
		$contactmethods['wpex_linkedin'] = WPEX_THEME_BRANDING .' - LinkedIn';
	}
	// Add Pinterest
	if ( !isset( $contactmethods['wpex_pinterest'] ) ) {
		$contactmethods['wpex_pinterest'] = WPEX_THEME_BRANDING .' - Pinterest';
	}
	// Add Pinterest
	if ( !isset( $contactmethods['wpex_instagram'] ) ) {
		$contactmethods['wpex_instagram'] = WPEX_THEME_BRANDING .' - Instagram';
	}
	return $contactmethods;
	}
endif;
add_filter( 'user_contactmethods', 'wpex_add_user_fields', 10, 1 );



/**
 * Checks if a user has social options defined
 *
 * @since 1.0
 */
if( !function_exists( 'wpex_contributor_has_social' ) ) :
	function wpex_contributor_has_social( $user_id = '' ) {
		if ( '' != get_the_author_meta( 'wpex_twitter', $user_id ) ) {
			return true;
		}
		elseif ( '' != get_the_author_meta( 'wpex_facebook', $user_id ) ) {
			return true;
		}
		elseif ( '' != get_the_author_meta( 'wpex_googleplus', $user_id ) ) {
			return true;
		}
		elseif ( '' != get_the_author_meta( 'wpex_linkedin', $user_id ) ) {
			return true;
		}
		elseif ( '' != get_the_author_meta( 'wpex_instagram', $user_id ) ) {
			return true;
		}
		// Display pinterest plus url
		elseif ( '' != get_the_author_meta( 'wpex_pinterest', $user_id ) ) {
			return true;
		} else {
			return false;
		}
	}
endif;