<?php
/**
 * Create simple social sharing buttons.
 *
 * @package WordPress
 * @subpackage Total
 * @since Total 1.0
*/


if ( !function_exists( 'wpex_social_share' ) ) :
	function wpex_social_share( $postid = '' ) {

		// Array
		$services_array = array( 'twitter', 'facebook', 'google_plus', 'pinterest', 'linkedin' );

		// Disabled
		if ( ! get_theme_mod( 'wpex_social_share', '1' ) ) {
			return;
		}

		// No Social options added
		if ( ! is_array( get_theme_mod( 'wpex_social_share_services', $services_array ) ) ) {
			return;
		}

		// Get post ID
		if( $postid ) {
			$postid = $postid;
		} else {
			global $post;
			$postid = $post->ID;
		}
		
		// If disabled show nothing
		if ('on' == get_post_meta( $postid, 'wpex_disable_social', true ) ) {
			return;
		}
		
		// Vars
		$permalink = get_permalink( $postid );
		$url = urlencode( $permalink );
		$title = urlencode( esc_attr( the_title_attribute( 'echo=0' ) ) );
		$summary = urlencode( wp_trim_words( get_the_content( $postid ), '40' ) );
		$img = urlencode( wp_get_attachment_url( get_post_thumbnail_id( $postid ) ) );
		$source = urlencode( home_url() );
		$services_array = get_theme_mod( 'wpex_social_share_services', $services_array );
		$services_array = array_combine( $services_array, $services_array );
		$social_share_title = __( 'Please Share', 'wpex' );
		$social_share_title = apply_filters( 'wpex_social_share_title', $social_share_title ); ?>

		<div class="social-share clr">
			<?php
			// Loop through services
			foreach( $services_array as $service ) {
				switch( $service ) {
					case 'twitter': ?>
						<a href="http://twitter.com/share?text=<?php echo $title; ?>&amp;url=<?php echo $url; ?>" target="_blank" title="<?php _e( 'Share on Twitter', 'wpex' ); ?>" rel="nofollow" class="twitter-share" onclick="javascript:window.open(this.href,
				'', 'menubar=no,toolbar=no,resizable=yes,scrollbars=yes,height=600,width=600');return false;"><span class="fa fa-twitter"></span>Tweet</a>
					<?php
					break;
					case 'facebook': ?>
						<a href="http://www.facebook.com/share.php?u=<?php echo $url; ?>" target="_blank" title="<?php _e( 'Share on Facebook', 'wpex' ); ?>" rel="nofollow" class="facebook-share" onclick="javascript:window.open(this.href,
				'', 'menubar=no,toolbar=no,resizable=yes,scrollbars=yes,height=600,width=600');return false;"><span class="fa fa-facebook-square"></span>Like</a>
						<?php
					break;
					case 'google_plus': ?>
						<a title="<?php _e( 'Share on Google+', 'wpex' ); ?>" rel="external" href="https://plus.google.com/share?url=<?php echo $url; ?>" class="googleplus-share" onclick="javascript:window.open(this.href,
				'', 'menubar=no,toolbar=no,resizable=yes,scrollbars=yes,height=600,width=600');return false;"><span class="fa fa-google-plus"></span>Plus</a>
					<?php
					break;
					case 'pinterest': ?>
						<a href="http://pinterest.com/pin/create/button/?url=<?php echo $url; ?>&amp;media=<?php echo $img; ?>&amp;description=<?php echo $summary; ?>" target="_blank" title="<?php _e( 'Share on Pinterest', 'wpex' ); ?>" rel="nofollow" class="pinterest-share" onclick="javascript:window.open(this.href,
				'', 'menubar=no,toolbar=no,resizable=yes,scrollbars=yes,height=600,width=600');return false;"><span class="fa fa-pinterest"></span>Pin It</a>
					<?php
					break;
					case 'linkedin': ?>
						<a title="<?php _e( 'Share on LinkedIn', 'wpex' ); ?>" href="http://www.linkedin.com/shareArticle?mini=true&amp;url=<?php echo $url; ?>&amp;title=<?php echo $title; ?>&amp;summary=<?php echo $summary; ?>&amp;source=<?php echo $source; ?>" target="_blank" rel="nofollow" class="linkedin-share" onclick="javascript:window.open(this.href,
				'', 'menubar=no,toolbar=no,resizable=yes,scrollbars=yes,height=600,width=600');return false;"><span class="fa fa-linkedin"></span>Share</a>
				<?php }
			} ?>
		</div>

	<?php
	}
endif;