<?php
/**
 * This file loads custom css and js for our theme
 *
 * @package WordPress
 * @subpackage Spartan WPExplorer Theme
 * @since Spartan 1.0
*/

if( ! function_exists( 'wpex_load_scripts' ) ) {
	function wpex_load_scripts() {

		/**
		 * Load all theme CSS
		 *
		 * @since 1.0
		 */

		// Main CSS
		wp_enqueue_style( 'wpex-style', get_stylesheet_uri(), false, '2.0' );

		// Responsive CSS
		if ( get_theme_mod( 'wpex_responsive', '1' ) ) {
			wp_enqueue_style( 'wpex-responsive', get_template_directory_uri() .'/css/responsive.css', array( 'wpex-style' ), '1.0' );
		}

		// Remove Contact Form 7 Styles
		if ( function_exists( 'wpcf7_enqueue_styles') ) {
			wp_dequeue_style( 'contact-form-7' );
		}

		// Remove symple shortcodes font awesome
		wp_dequeue_style( 'symple_shortcodes_font_awesome' );

		/**
		 * Load all theme JS files
		 *
		 * @since 1.0
		 */

		// Threaded commments
		if ( is_singular() && comments_open() && get_option( 'thread_comments' ) ) {
			wp_enqueue_script( 'comment-reply' );
		}

		// Retina Support
		if ( get_theme_mod( 'wpex_retina' ) ) {
			wp_enqueue_script( 'wpex-retina', WPEX_JS_DIR_URI .'retina.js', array( 'jquery' ), '', true );
		}

		// Main js plugins
		wp_enqueue_script( 'wpex-plugins', WPEX_JS_DIR_URI .'plugins.js', array( 'jquery' ), '1.0', true );

		// Init
		wp_enqueue_script( 'wpex-global', WPEX_JS_DIR_URI .'global.js', array( 'jquery' ), '1.0', true );

		// Localize
		$home_slideshow = get_theme_mod( 'wpex_homepage_slider_slideshow' );
		$home_slideshow = $home_slideshow ? 'true' : 'false';
		$home_slideshow_speed  = get_theme_mod( 'wpex_homepage_slider_slideshow_speed', '7000' );
		$localize_array = array(
			'mobileMenuOpen'		=> get_theme_mod( 'wpex_mobile_menu_open_text', __( 'Browser Categories', 'wpex' ) ),
			'mobileMenuClosed'		=> get_theme_mod( 'wpex_mobile_menu_close_text', __( 'Close navigation', 'wpex' ) ),
			'homeSlideshow'			=> $home_slideshow,
			'homeSlideshowSpeed'	=> $home_slideshow_speed,
			'UsernamePlaceholder'	=> __( 'Username', 'wpex' ),
			'PasswordPlaceholder'	=> __( 'Password', 'wpex' ),
			'enableFitvids'			=> 'true',
		);
		$localize_array = apply_filters( 'wpex_localize_array', $localize_array );
		wp_localize_script( 'wpex-global', 'wpexLocalize', $localize_array );
	}
}
add_action( 'wp_enqueue_scripts','wpex_load_scripts' );

/**
 * Adds CSS for ie8
 *
 * @since 1.0
 */
if ( !function_exists( 'wpex_ie8_css' ) ) {
	function wpex_ie8_css() {
		echo '<!--[if IE 8]><link rel="stylesheet" type="text/css" href="'. WPEX_CSS_DIR_URI .'ie8.css" media="screen"><![endif]-->';
	}
}
add_action( 'wp_head', 'wpex_ie8_css' );