<?php
/**
 * Used to display related portfolio items
 *
 * @package WordPress
 * @subpackage Spartan
 * @since Spartan 1.1
*/


if ( ! function_exists( 'wpex_related_posts' ) ) :
	function wpex_related_posts() {
		
		// Return if disabled
		if ( ! get_theme_mod( 'wpex_related_posts', '1' ) ) {
			return;
		}
		
		// Return if pass required
		if ( post_password_required() ) {
			return;
		}
		
		// Get Post Data
		global $post;
		$post_id = $post->ID;

		// Return if not standard post type
		if ( 'post' != get_post_type( $post_id ) ) {
			return;
		}

		// Theme Settings
		$disable_related_items = get_post_meta( $post_id, 'wpex_disable_related_items', true );
	
		// Create an array of current category ID's
		$cats = wp_get_post_terms( $post_id, 'category' ); 
		$cats_ids = array();  
		foreach( $cats as $wpex_related_cat ) {
			$cats_ids[] = $wpex_related_cat->term_id; 
		}

		// Related exclude formats
		$exclude_formats = array( 'post-format-quote', 'post-format-link', 'post-format-status' );
		$exclude_formats = apply_filters( 'wpex_related_posts_exclude_formats', $exclude_formats );
		
		// Related query arguments
		$args = array(
			'posts_per_page'		=> '8',
			'orderby'				=> 'rand',
			'category__in'			=> $cats_ids,
			'post__not_in'			=> array( $post_id ),
			'no_found_rows'			=> true,
			'meta_key'				=> '_thumbnail_id',
			'tax_query'				=> array (
			'relation'	=> 'AND',
				array (
					'taxonomy'	=> 'post_format',
					'field'		=> 'slug',
					'terms'		=> $exclude_formats,
					'operator'	=> 'NOT IN',
				),
			),
		);
		$wpex_query = new wp_query( $args );
		if( $wpex_query->have_posts() ) { ?>
			<div class="related-carousel-wrap clr">
				<div class="heading"><?php _e( 'Related Posts', 'wpex' ); ?></div>
				<div class="related-carousel owl-carousel clr count-<?php echo count( $wpex_query->posts ); ?>">
					<?php
					// Loop through related posts
					foreach( $wpex_query->posts as $post ) : setup_postdata( $post );
						get_template_part( 'content', 'related' );
					endforeach; ?>
				</div><!-- .related-carousel -->
			</div>
		<?php } // End related items
		
		// Reset query
		//wp_reset_query();
		wp_reset_postdata();
		
	}
endif;