<?php
/**
 * Outputs the post video
 * Based on the wpex_post_video custom field
 *
 * @package WordPress
 * @subpackage Spartan WPExplorer Theme
 * @since Spartan 1.0
 */

if ( ! function_exists( 'wpex_post_video' ) ) :
	function wpex_post_video() {
		$video_url = get_post_meta( get_the_ID(), 'wpex_post_video', true );
		$video_embed = get_post_meta( get_the_ID(), 'wpex_post_video_embed', true );
		if( $video_embed ) {
			echo '<div class="post-video wpex-video-embed clr">'. $video_embed .'</div>';
		} elseif ( $video_url ) {
			echo '<div class="post-video wpex-video-embed clr">'. apply_filters( 'the_content', $video_url ) .'</div>';
		} else {
			return;
		}
	}
endif;