<?php
/**
 * Used to output post meta info
 *
 * @package WordPress
 * @subpackage Spartan WPExplorer Theme
 * @since Spartan 1.0
 */


// Remove rels on categories
if ( ! function_exists( 'wpex_remove_category_list_rel' ) ) :
	function wpex_remove_category_list_rel( $output ) {
		return str_replace( ' rel="category tag"', '', $output );
	}
endif;
add_filter( 'wp_list_categories', 'wpex_remove_category_list_rel' );
add_filter( 'the_category', 'wpex_remove_category_list_rel' );


// Output Post Meta
if ( ! function_exists( 'wpex_post_meta' ) ) :
	function wpex_post_meta() {

		/** Singular Posts **/
		if ( is_singular('post') && !post_password_required() ) {
			$array = get_theme_mod( 'wpex_post_meta', array( 'date', 'author', 'category', 'comments' ) );
			if ( ! is_array( $array ) ) {
				return;
			} ?>
		
			<div class="post-meta clr">
				<?php
				// Swap order if RTL
				if( is_rtl() ) {
					$array = array_reverse( $array );
				}
				// Loop through meta options
				foreach( $array as $item ) {
				switch( $item ) {
					// Date
					case 'date': ?>
					<span class="post-meta-date">
						<?php _e( 'Posted on', 'wpex' ); ?> <?php echo get_the_date(); ?>
					</span>
					<?php break;
					// Author
					case 'author': ?>
					<span class="post-meta-author">
						<?php _e( 'by', 'wpex' ); ?> <?php the_author_posts_link(); ?>
					</span>
					<?php break;
					// Category
					case 'category': ?>
					<span class="post-meta-category">
						<?php _e( 'in', 'wpex' ); ?> <?php the_category(', '); ?>
					</span>
					<?php break;
					// Comments
					case 'comments': ?>
					<?php if( comments_open() ) { ?>
						<span class="post-meta-comments">
							<?php _e( 'with', 'wpex' ); ?> <?php echo comments_popup_link(); ?>
						</span>
					<?php } ?>
				<?php } // END switch
				} // End foreach ?>
			</div><!-- .post-meta -->

		<?php }
		/** Post Entries **/
		if ( !is_singular('post') ) {
			if ( !get_theme_mod( 'wpex_blog_meta', '1' ) ) {
				return;
			}
			$array = get_theme_mod( 'wpex_entry_meta', array( 'date', 'comments' ) );
			if ( ! is_array( $array ) ) {
				return;
			} ?>
			<div class="loop-entry-meta clr">
			<?php
			// Swap order if RTL
			if( is_rtl() ) {
				$array = array_reverse( $array );
			}
			// Loop through meta options
			foreach( $array as $item ) {
				switch( $item ) {
					// Date
					case 'date': ?>
						<div class="loop-entry-meta-date">
							<span class="fa fa-clock-o"></span><?php echo get_the_date(); ?>
						</div>
					<?php break;
					// Author
					case 'author': ?>
					<div class="post-meta-author">
						<span class="fa fa-user"></span><?php the_author_posts_link(); ?>
					</div>
					<?php break;
					// Category
					case 'category': ?>
					<div class="loop-entry-meta-category">
						<span class="fa fa-folder"></span><?php the_category(', '); ?>
					</div>
					<?php break;
					// Comments
					case 'comments': ?>
					<?php if( comments_open() ) { ?>
						<div class="loop-entry-meta-comments">
							<span class="fa fa-comments"></span><?php echo comments_popup_link(); ?>
						</div>
					<?php } ?>
				<?php } // END switch
				} // End foreach ?>
			</div><!-- .loop-entry-meta -->
		<?php }

	}
endif;