<?php
/**
 * Outputs the post gallery
 *
 * @package WordPress
 * @subpackage Spartan WPExplorer Theme
 * @since Spartan 1.0
 */


if ( ! function_exists( 'wpex_gallery_attachments' ) ) :
	function wpex_gallery_attachments() {
		$attachments = wpex_get_gallery_ids();
		if ( ! empty( $attachments ) ) {
			return $attachments;
		} else {
			return false;
		}
	}
endif;

if ( ! function_exists( 'wpex_post_gallery' ) ) :
	function wpex_post_gallery() {
		global $post;
		$attachments = wpex_gallery_attachments();
		if ( ! $attachments ) {
			return;
		} ?>
		<div class="post-gallery owl-carousel wpex-gallery-lightbox">
			<?php
			// Loop through each image in each gallery
			foreach( $attachments as $attachment ) {
				// Get attachment data
				$attachment_data = wpex_get_attachment( $attachment );
				// Get Image
				$full_img = wp_get_attachment_url( $attachment );
				$img = wpex_image( 'array', $attachment );
				$img_url = $img['url'];
				$alt = isset( $attachment_data['alt'] ) ? $attachment_data['alt'] : '';
				$thumb_width = apply_filters( 'wpex_gallery_thumb_width', '65' );
				$thumb_height = apply_filters( 'wpex_gallery_thumb_height', '65' );
				$thumb_crop = apply_filters( 'wpex_gallery_thumb_crop', true );
				// Display Image
				if ( $img ) { ?>
					<div data-dot='<img src="<?php echo wpex_img_resize( $full_img, $thumb_width, $thumb_height, $thumb_crop ); ?>" alt="<?php echo $alt; ?>" />'>
						<figure>
							<?php if ( wpex_gallery_is_lightbox_enabled() ) { ?>
								<a href="<?php echo $full_img; ?>" title="<?php echo $alt; ?>">
							<?php } ?>
							<img src="<?php echo $img_url; ?>" alt="<?php echo $alt; ?>" width="<?php echo $img['width']; ?>" height="<?php echo $img['height']; ?>" />
							<?php if ( wpex_gallery_is_lightbox_enabled() ) {
								echo '<span class="overlay"></span></a>';
							} ?>
							<?php if ( is_singular() && '' != $attachment_data['caption'] ) { ?>
								<div class="post-gallery-caption"><?php echo $attachment_data['caption']; ?></div>
							<?php } ?>
						</figure>
					</div>
				<?php } ?>
			<?php } ?>
		</div><!-- .post-gallery -->
	<?php
	}
endif;