<?php
/**
 * Returns the font awesome icon for the post format
 *
 * @package WordPress
 * @subpackage Spartan WPExplorer Theme
 * @since Spartan 1.0
 */


if ( ! function_exists( 'wpex_post_format_icon' ) ) {
	function wpex_post_format_icon() {
		global $post;
		$post_id = $post->ID;
		$format = get_post_format();
		// Video
		if ( 'video' == $format ) {
			$icon = 'fa-film';
		}
		// Audio
		if ( 'audio' == $format ) {
			$icon = 'fa-music';
		}
		// Gallery
		elseif ( 'gallery' == $format ) {
			$icon = 'fa-file-photo-o';
		}
		// Quote
		elseif ( 'quote' == $format ) {
			$icon = 'fa-quote-left';
		}
		// Standard
		else {
			$icon = 'fa-file-text-o';
		}
		$icon = apply_filters( 'wpex_post_format_icon', $icon );
		echo $icon;
	}
}