<?php
/**
 * Displays post featured image
 *
 * @package WordPress
 * @subpackage Spartan WPExplorer Theme
 * @since Spartan 1.0
 */


if ( ! function_exists( 'wpex_post_featured_image' ) ) {
	function wpex_post_featured_image() {
		global $post;
		$post_id = $post->ID;
		if ( !has_post_thumbnail( $post_id ) ) {
			return;
		}
		if ( !get_theme_mod( 'wpex_blog_post_thumb', '1' ) ) {
			return;
		}
		if ( 'on' == get_post_meta( $post_id, 'wpex_disable_featured_image', true ) ) {
			return;
		}
		$img = wpex_image( 'array' ); ?>
		<div class="post-thumbnail">
			<img src="<?php echo $img['url']; ?>" alt="<?php echo esc_attr( the_title_attribute( 'echo=0' ) ); ?>" width="<?php echo $img['width']; ?>" height="<?php echo $img['height']; ?>" />
		</div><!-- .post-thumbnail -->
	<?php
	}
}