<?php
/**
 * Adds classes to entries
 *
 * @package WordPress
 * @subpackage Spartan WPExplorer Theme
 * @since Spartan 1.0
 */

if ( ! function_exists( 'wpex_post_entry_classes' ) ) :
	function wpex_post_entry_classes( $classes ) {
		
		// Post Data
		global $post, $wpex_count;
		$post_id = $post->ID;
		$post_type = get_post_type( $post_id );

		// Entry classes
		if( ! is_singular() ) {
			$classes[] = 'loop-entry';
			if ( 'post' != $post_type ) {
				$classes[] = $post_type .'-entry';
			}
		}

		// Add Categories
		$post_terms = get_the_terms( $post, 'category' );
		if ( $post_terms ) {
			foreach ( $post_terms as $post_term ) {
				$classes[] = 'cat-'. $post_term->term_id;
			}
		}

		// Counter
		if( $wpex_count ) {
			$classes[] = 'col-'. $wpex_count;
		}

		// No thumbnail
		if( ! has_post_thumbnail() && 'video' != get_post_format() ) {
			$classes[] = 'no-thumbnail';
		}

		// Cookie based column class
		if( isset( $_COOKIE["wpex-entry-columns"] ) ) {
			$cookie = $_COOKIE["wpex-entry-columns"];
		} else {
			$cookie = '';
		}
		if ( 'two-columns' == get_theme_mod( 'wpex_entry_style' ) && 'disabled' != $cookie ) {
			$classes[] = 'col';
		} elseif( 'enabled' == $cookie ) {
			$classes[] = 'col';
		} 

		// Return classes
		return $classes;
		
	}
endif;
add_filter( 'post_class', 'wpex_post_entry_classes' );