<?php
/**
 * Used for next and previous post links
 *
 * @package WordPress
 * @subpackage Spartan WPExplorer Theme
 * @since Spartan 1.0
*/


// Display next/previous links
if ( ! function_exists( 'wpex_next_prev' ) ) {
	function wpex_next_prev() {
		global $post;
		if ( !is_singular() ) return;
		if ( !get_theme_mod( 'wpex_next_prev', '1' ) ) return; ?>
		<?php
		// Output the next/previous links ?>
		<div class="next-prev clr">
			<?php
			// Previous post link
			if( is_rtl() ) {
				$img = get_template_directory_uri() .'/images/next-post.png';
			} else {
				$img = get_template_directory_uri() .'/images/prev-post.png';
			}
			next_post_link(
				'<div class="post-prev">%link</div>',
				'<img src="'. $img .'" alt="'. __( 'Next Article', 'wpex' ) .'" />'. __( 'Previous Article', 'wpex' ) .''
			);
			// Next post link
			if( is_rtl() ) {
				$img = get_template_directory_uri() .'/images/prev-post.png';
			} else {
				$img = get_template_directory_uri() .'/images/next-post.png';
			}
			previous_post_link(
				'<div class="post-next">%link</div>',
				'<img src="'. $img .'" alt="'. __( 'Next Article', 'wpex' ) .'" />'. __( 'Next Article', 'wpex' ) .''
			); ?>
		</div><!-- .post-post-pagination -->
	<?php }
}