<?php
/**
 * Outputs the site logo 
 * @package WordPress
 * @subpackage Spartan WPExplorer Theme
 * @since Spartan 1.0
 */


/**
 * Returns the Logo URL
 *
 * @since Spartan 1.0
 */
if ( ! function_exists( 'wpex_logo_img_src' ) ) :
	function wpex_logo_img_src() {
		$src = get_theme_mod( 'wpex_logo', get_template_directory_uri(). '/images/logo.png' );
		$src = apply_filters( 'wpex_logo_img', $src );
		if ( $src ) {
			return $src;
		} else {
			return false;
		}
	}
endif;

/**
 * Outputs the logo in the header
 *
 * @since Spartan 1.0
 */
if ( ! function_exists( 'wpex_logo' ) ) :
	function wpex_logo() {
		$logo_img = wpex_logo_img_src();
		$blog_name = get_bloginfo( 'name' ); ?>
		<div id="logo" class="clr">
			<?php
			if( is_front_page() ) {
				$open_tag = '<h1>';
				$close_tag = '</h1>';
			} else {
				$open_tag = '<h2>';
				$close_tag = '</h2>';
			} ?>
			<?php if ( $logo_img ) {
				echo $open_tag; ?>
				<a href="<?php echo home_url(); ?>" title="<?php echo $blog_name; ?>" rel="home"><img src="<?php echo $logo_img; ?>" alt="<?php echo $blog_name; ?>" /></a>
			<?php
				echo $close_tag;
			} else { ?>
				<div class="site-text-logo clr">
					<?php echo $open_tag; ?>
						<a href="<?php echo home_url(); ?>" title="<?php echo $blog_name; ?>" rel="home"><?php echo $blog_name; ?></a>
					<?php echo $close_tag; ?>
				</div>
			<?php } ?>
		</div><!-- #logo -->
		<?php
	}
endif;

/**
 * Adds code for the retina logo
 *
 * @since Spartan 1.0
 */
if ( ! function_exists( 'wpex_retina_logo' ) ) :
	function wpex_retina_logo() {
		$logo_url = get_theme_mod( 'wpex_retina_logo' );
		$logo_height = get_theme_mod( 'wpex_retina_logo_height' );
		if ( '' != $logo_url && '' != $logo_height) {
			$output = '<!-- Retina Logo --><script type="text/javascript">jQuery(function($){if (window.devicePixelRatio == 2) {$("#logo img").attr("src", "'. esc_url( $logo_url ) .'");$("#logo img").css("height", "'. intval( $logo_height ) .'");}});</script>';
			echo $output;
		}
	}
endif;
add_action( 'wp_head', 'wpex_retina_logo' );