<?php
/**
 * Exclude posts from the homepage
 *
 * @package WordPress
 * @subpackage Spartan WPExplorer Theme
 * @since Spartan 1.0
 */

if ( ! function_exists( 'wpex_exclude_home_ids' ) ) {
	function wpex_exclude_home_ids(){
		// Slider settings & main vars
		$slider_exclude = get_theme_mod( 'wpex_homepage_slider_exclude_posts', '1' );
		if ( ! $slider_exclude ) {
			return;
		}
		$array = array();
		$slider_content = get_theme_mod( 'wpex_homepage_slider_content', 'recent_posts' );
		$slider_count = get_theme_mod( 'wpex_homepage_slider_count', '3' );
		// Build array of posts to exclude
		if( $slider_content && 'none' != $slider_content && $slider_count >= 1 ) {
			if ( 'recent_posts' == $slider_content ) {
				$posts = get_posts( array(
					'post_type'			=> 'post',
					'posts_per_page'	=> $slider_count,
					'meta_key'			=> '_thumbnail_id',
				) );
				if ( $posts ) {
					foreach( $posts as $post ) {
						$array[] = $post->ID;
					}
				}
			} elseif ( 'none' != $slider_content ) {
				$posts = get_posts( array(
					'post_type'			=> 'post',
					'posts_per_page'	=> $slider_count,
					'meta_key'			=> '_thumbnail_id',
					'tax_query'			=> array (
						array (
							'taxonomy'	=> 'category',
							'field'		=> 'ID',
							'terms'		=> $slider_content,
						)
					)
				) );
				if ( $posts ) {
					foreach( $posts as $post ) {
						$array[] = $post->ID;
					}
				}
			}
		}
		return $array;
	}
}

if ( ! function_exists( 'wpex_exclude_home_posts' ) ) {
	function wpex_exclude_home_posts( $query ){
		// Exclude posts
		if ( $query->is_home() AND $query->is_main_query() ) {
			if ( function_exists( 'wpex_exclude_home_ids' ) ) {
				$array = wpex_exclude_home_ids();
				if ( is_array( $array ) && !empty( $array ) ) {
					$query->set('post__not_in', $array );
				}
			}
		}
	}
}
add_filter( 'pre_get_posts', 'wpex_exclude_home_posts' );