<?php
/**
 * This file is used for all excerpt related functions
 *
 * @package WordPress
 * @subpackage Spartan WPExplorer Theme
 * @since Spartan 1.0
*/


/**
 * Custom excerpts based on wp_trim_words
 * Created for child-theming purposes
 * 
 * Learn more at http://codex.wordpress.org/Function_Reference/wp_trim_words
 *
 * @since Spartan 1.0
*/
if ( !function_exists( 'wpex_excerpt' ) ) :
	function wpex_excerpt( $length=25, $readmore=true ) {
		$length = get_theme_mod( 'wpex_excerpt_length', '25' );
		if ( ! $length || ! is_numeric( $length ) ) {
			return;
		}
		$length = intval( $length );
		// Main vars
		global $post;
		$id = $post->ID;
		$output = '';
		// Check if read more is enabled
		if ( $readmore ) {
			if( get_theme_mod( 'wpex_blog_readmore' ) ) {
				$readmore = true;
			} else {
				$readmore = false;
			}
		}
		// Readmore text
		$readmore_text = get_theme_mod( 'wpex_readmore_text', __( 'Read More', 'wpex' ) );
		if( '' == $readmore_text ) {
			$readmore_text = __( 'Read More', 'wpex' );
		}
		// Readmore link HTML
		$readmore_link = '<div class="wpex-readmore">
			<a href="'. get_permalink( $id ) .'" title="'. $readmore_text .'" rel="bookmark">';
				$readmore_link .= '<span class="text">'. $readmore_text .'</span>';
				if ( is_rtl() ) {
					$readmore_link .= '<span class="arrow">&larr;</span>';
				} else {
					$readmore_link .= '<span class="arrow">&rarr;</span>';
				}
			$readmore_link .= '</a>
		</div>';
		// Display custom excerpt
		if ( has_excerpt( $id ) ) {
			$output = $post->post_excerpt;
			if ( $readmore ) {
				$output .= apply_filters( 'wpex_readmore_link', $readmore_link );
			}
		} else {
			if( ! is_single() && ! get_theme_mod( 'wpex_ignore_more_tag' ) && strpos( $post->post_content, '<!--more-->' )  ) {
				the_content( '' );
			} else {
				$output = wp_trim_words( strip_shortcodes( get_the_content( $id ) ), $length, '&hellip;' );
			}
			if ( $readmore ) {
				$output .= apply_filters( 'wpex_readmore_link', $readmore_link );
			}
		}
		if ( isset( $output ) && '' != $output ) {
			echo $output;
		}
	}
endif;

/**
 * Change default excerpt read more style
 * @since Spartan 1.0
*/
if ( !function_exists( 'wpex_excerpt_more' ) ) :
	function wpex_excerpt_more( $more ) {
		global $post;
		return '&hellip;';
	}
endif;
add_filter( 'excerpt_more', 'wpex_excerpt_more' );