<?php
/**
 * Adds classes to entries
 *
 * @package WordPress
 * @subpackage Spartan WPExplorer Theme
 * @since Spartan 1.0
 */


if ( ! function_exists( 'wpex_entry_overlay' ) ) {
	function wpex_entry_overlay() {
		$format = get_post_format();
		$icon = '<span class="fa fa-plus"></span>';
		if ( 'post' == $format ) {
			if ( get_theme_mod( 'wpex_entry_img_lightbox' ) ) {
				$icon = '<span class="fa fa-search"></span>';
			} else {
				$icon = '<span class="fa fa-plus"></span>';
			}
		} elseif ( 'audio' == $format ) {
			$icon = '<span class="fa fa-music"></span>';
		} elseif ('video' == $format ) {
			$icon = '<span class="fa fa-play"></span>';
		}
		$icon = apply_filters( 'wpex_overlay_icon', $icon ); ?>
			<div class="loop-entry-overlay">
				<div class="loop-entry-overlay-icon clr"><div class="loop-entry-overlay-icon-inner"><?php echo $icon; ?></div></div>
			</div>
		<?php
	}
}