/**
 * Theme Customizer enhancements for a better user experience.
 *
 * Contains handlers to make Theme Customizer preview reload changes asynchronously.
 */
( function( $ ) {
	// Site title
	wp.customize( 'blogname', function( value ) {
		value.bind( function( newval ) {
			$( '.site-text-logo a' ).text( newval );
		} );
	} );
	// Subheading
	wp.customize( 'wpex_logo_subheading', function( value ) {
		value.bind( function( newval ) {
			$( '#blog-description' ).html( newval );
		} );
	} );
	// Header Padding
	wp.customize( 'wpex_header_top_pad', function( value ) {
		value.bind( function( newval ) {
			if ( ! newval ) {
				$( '#header-wrap' ).css( {
					'paddingTop': '50'
				});
			} else {
				$( '#header-wrap' ).css( {
					'paddingTop': parseInt( newval )
				});
			}
		} );
	} );
	// Header Padding
	wp.customize( 'wpex_header_bottom_pad', function( value ) {
		value.bind( function( newval ) {
			if ( !newval ) {
				$( '#header-wrap' ).css( {
					'paddingBottom': '50'
				});
			} else {
				$( '#header-wrap' ).css( {
					'paddingBottom': parseInt( newval )
				});
			}
		} );
	} );
	// Mobile Text
	wp.customize( 'wpex_mobile_menu_open_text', function( value ) {
		value.bind( function( newval ) {
			$( '.navigation-toggle-text' ).text( newval );
		} );
	} );
	// Color options
	wp.customize( 'wpex_topbar_bg', function( value ) { value.bind( function( newval ) { if ( newval ) { $( '#topbar' ).css('background-color', newval ); } else { $( '#topbar' ).css('background-color', ''); } } ); } ); wp.customize( 'wpex_topbar_border', function( value ) { value.bind( function( newval ) { if ( newval ) { $( '#topbar' ).css('border-color', newval ); } else { $( '#topbar' ).css('border-color', ''); } } ); } ); wp.customize( 'wpex_topbar_date_borders', function( value ) { value.bind( function( newval ) { if ( newval ) { $( '#topbar-date' ).css('border-color', newval ); } else { $( '#topbar-date' ).css('border-color', ''); } } ); } ); wp.customize( 'wpex_topbar_color', function( value ) { value.bind( function( newval ) { if ( newval ) { $( '#topbar, #topbar p' ).css('color', newval ); } else { $( '#topbar, #topbar p' ).css('color', ''); } } ); } ); wp.customize( 'wpex_topbar_link_color', function( value ) { value.bind( function( newval ) { if ( newval ) { $( '#topbar a' ).css('color', newval ); } else { $( '#topbar a' ).css('color', ''); } } ); } ); wp.customize( 'wpex_topbar_link_hover_color', function( value ) { value.bind( function( newval ) { if ( newval ) { $( '#topbar a:hover' ).css('color', newval ); } else { $( '#topbar a:hover' ).css('color', ''); } } ); } ); wp.customize( 'wpex_topbar_menu_divider_color', function( value ) { value.bind( function( newval ) { if ( newval ) { $( '#topbar-nav .sf-menu > li:after' ).css('background-color', newval ); } else { $( '#topbar-nav .sf-menu > li:after' ).css('background-color', ''); } } ); } ); wp.customize( 'wpex_topbar_menu_bottom_border_color', function( value ) { value.bind( function( newval ) { if ( newval ) { $( '#topbar-nav .sf-menu > li > a' ).css('border-color', newval ); } else { $( '#topbar-nav .sf-menu > li > a' ).css('border-color', ''); } } ); } ); wp.customize( 'wpex_topbar_menudropdown_bg', function( value ) { value.bind( function( newval ) { if ( newval ) { $( '#topbar-nav .sf-menu .sub-menu' ).css('background-color', newval ); } else { $( '#topbar-nav .sf-menu .sub-menu' ).css('background-color', ''); } } ); } ); wp.customize( 'wpex_topbar_menudropdown_borders', function( value ) { value.bind( function( newval ) { if ( newval ) { $( '#topbar-nav .sf-menu .sub-menu a' ).css('border-color', newval ); } else { $( '#topbar-nav .sf-menu .sub-menu a' ).css('border-color', ''); } } ); } ); wp.customize( 'wpex_topbar_menudropdown_link_color', function( value ) { value.bind( function( newval ) { if ( newval ) { $( '#topbar-nav .sf-menu .sub-menu a' ).css('color', newval ); } else { $( '#topbar-nav .sf-menu .sub-menu a' ).css('color', ''); } } ); } ); wp.customize( 'wpex_topbar_menudropdown_link_hover_color', function( value ) { value.bind( function( newval ) { if ( newval ) { $( '#topbar-nav .sf-menu .sub-menu a:hover' ).css('color', newval ); } else { $( '#topbar-nav .sf-menu .sub-menu a:hover' ).css('color', ''); } } ); } ); wp.customize( 'wpex_topbar_search_bg', function( value ) { value.bind( function( newval ) { if ( newval ) { $( '.topbar-searchform-input' ).css('background-color', newval ); } else { $( '.topbar-searchform-input' ).css('background-color', ''); } } ); } ); wp.customize( 'wpex_topbar_search_border_color', function( value ) { value.bind( function( newval ) { if ( newval ) { $( '.topbar-searchform-input' ).css('border-color', newval ); } else { $( '.topbar-searchform-input' ).css('border-color', ''); } } ); } ); wp.customize( 'wpex_topbar_search_color', function( value ) { value.bind( function( newval ) { if ( newval ) { $( '.topbar-searchform-input' ).css('color', newval ); } else { $( '.topbar-searchform-input' ).css('color', ''); } } ); } ); wp.customize( 'wpex_topbar_search_icon_color', function( value ) { value.bind( function( newval ) { if ( newval ) { $( '.header-searchform-btn' ).css('color', newval ); } else { $( '.header-searchform-btn' ).css('color', ''); } } ); } ); wp.customize( 'wpex_topbar_mobile_icons_color', function( value ) { value.bind( function( newval ) { if ( newval ) { $( '#topbar .topbar-nav-mobile-toggle, #topbar .topbar-search-mobile-toggle, #topbar .topbar-mobile-login-link' ).css('color', newval ); } else { $( '#topbar .topbar-nav-mobile-toggle, #topbar .topbar-search-mobile-toggle, #topbar .topbar-mobile-login-link' ).css('color', ''); } } ); } ); wp.customize( 'wpex_topbar_mobile_icons_borders', function( value ) { value.bind( function( newval ) { if ( newval ) { $( '#topbar .container, #topbar .topbar-nav-mobile-toggle, #topbar .topbar-search-mobile-toggle, #topbar .topbar-mobile-login-link' ).css('border-color', newval ); } else { $( '#topbar .container, #topbar .topbar-nav-mobile-toggle, #topbar .topbar-search-mobile-toggle, #topbar .topbar-mobile-login-link' ).css('border-color', ''); } } ); } ); wp.customize( 'wpex_topbar_mobile_menu_link_color', function( value ) { value.bind( function( newval ) { if ( newval ) { $( '.wpex-mobile-top-nav-ul li a' ).css('color', newval ); } else { $( '.wpex-mobile-top-nav-ul li a' ).css('color', ''); } } ); } ); wp.customize( 'wpex_topbar_mobile_menu_link_hover_color', function( value ) { value.bind( function( newval ) { if ( newval ) { $( '.wpex-mobile-top-nav-ul li a:hover' ).css('color', newval ); } else { $( '.wpex-mobile-top-nav-ul li a:hover' ).css('color', ''); } } ); } ); wp.customize( 'wpex_topbar_mobile_menu_link_border_color', function( value ) { value.bind( function( newval ) { if ( newval ) { $( '.wpex-mobile-top-nav-ul li a' ).css('border-color', newval ); } else { $( '.wpex-mobile-top-nav-ul li a' ).css('border-color', ''); } } ); } ); wp.customize( 'wpex_header_bg_color', function( value ) { value.bind( function( newval ) { if ( newval ) { $( '#top-wrap' ).css('background-color', newval ); } else { $( '#top-wrap' ).css('background-color', ''); } } ); } ); wp.customize( 'wpex_logo_color', function( value ) { value.bind( function( newval ) { if ( newval ) { $( '.site-text-logo a' ).css('color', newval ); } else { $( '.site-text-logo a' ).css('color', ''); } } ); } ); wp.customize( 'wpex_subheading_color', function( value ) { value.bind( function( newval ) { if ( newval ) { $( '#blog-description' ).css('color', newval ); } else { $( '#blog-description' ).css('color', ''); } } ); } ); wp.customize( 'wpex_nav_bg', function( value ) { value.bind( function( newval ) { if ( newval ) { $( '#site-navigation-inner, #site-navigation-wrap.is-sticky' ).css('background-color', newval ); } else { $( '#site-navigation-inner, #site-navigation-wrap.is-sticky' ).css('background-color', ''); } } ); } ); wp.customize( 'wpex_nav_top_border', function( value ) { value.bind( function( newval ) { if ( newval ) { $( '#site-navigation-inner' ).css('border-top-color', newval ); } else { $( '#site-navigation-inner' ).css('border-top-color', ''); } } ); } ); wp.customize( 'wpex_nav_link_border_color', function( value ) { value.bind( function( newval ) { if ( newval ) { $( '.header-search-icon,#site-navigation .dropdown-menu > li' ).css('border-color', newval ); } else { $( '.header-search-icon,#site-navigation .dropdown-menu > li' ).css('border-color', ''); } } ); } ); wp.customize( 'wpex_nav_link_color', function( value ) { value.bind( function( newval ) { if ( newval ) { $( '#site-navigation .dropdown-menu > li > a, a.navigation-toggle' ).css('color', newval ); } else { $( '#site-navigation .dropdown-menu > li > a, a.navigation-toggle' ).css('color', ''); } } ); } ); wp.customize( 'wpex_nav_link_active_color', function( value ) { value.bind( function( newval ) { if ( newval ) { $( '#site-navigation .dropdown-menu > .current-menu-item > a,#site-navigation .dropdown-menu > .current-menu-ancestor > a,#site-navigation .dropdown-menu > .current-menu-parent > a' ).css('color', newval ); } else { $( '#site-navigation .dropdown-menu > .current-menu-item > a,#site-navigation .dropdown-menu > .current-menu-ancestor > a,#site-navigation .dropdown-menu > .current-menu-parent > a' ).css('color', ''); } } ); } ); wp.customize( 'wpex_nav_link_active_bg', function( value ) { value.bind( function( newval ) { if ( newval ) { $( '#site-navigation .dropdown-menu > .current-menu-item > a,#site-navigation .dropdown-menu > .current-menu-ancestor > a,#site-navigation .dropdown-menu > .current-menu-parent > a' ).css('background-color', newval ); } else { $( '#site-navigation .dropdown-menu > .current-menu-item > a,#site-navigation .dropdown-menu > .current-menu-ancestor > a,#site-navigation .dropdown-menu > .current-menu-parent > a' ).css('background-color', ''); } } ); } ); wp.customize( 'wpex_nav_drop_bg', function( value ) { value.bind( function( newval ) { if ( newval ) { $( '#site-navigation-wrap .dropdown-menu ul' ).css('background-color', newval ); } else { $( '#site-navigation-wrap .dropdown-menu ul' ).css('background-color', ''); } } ); } ); wp.customize( 'wpex_nav_drop_border', function( value ) { value.bind( function( newval ) { if ( newval ) { $( '#site-navigation-wrap .dropdown-menu ul' ).css('border-color', newval ); } else { $( '#site-navigation-wrap .dropdown-menu ul' ).css('border-color', ''); } } ); } ); wp.customize( 'wpex_nav_drop_link_border', function( value ) { value.bind( function( newval ) { if ( newval ) { $( '#site-navigation .dropdown-menu ul li' ).css('border-color', newval ); } else { $( '#site-navigation .dropdown-menu ul li' ).css('border-color', ''); } } ); } ); wp.customize( 'wpex_nav_drop_link_color', function( value ) { value.bind( function( newval ) { if ( newval ) { $( '#site-navigation .dropdown-menu ul > li > a' ).css('color', newval ); } else { $( '#site-navigation .dropdown-menu ul > li > a' ).css('color', ''); } } ); } ); wp.customize( 'wpex_mobile_nav_bg', function( value ) { value.bind( function( newval ) { if ( newval ) { $( '.wpex-mobile-nav .container' ).css('background-color', newval ); } else { $( '.wpex-mobile-nav .container' ).css('background-color', ''); } } ); } ); wp.customize( 'wpex_mobile_nav_link_color', function( value ) { value.bind( function( newval ) { if ( newval ) { $( '.wpex-mobile-nav-ul li a' ).css('color', newval ); } else { $( '.wpex-mobile-nav-ul li a' ).css('color', ''); } } ); } ); wp.customize( 'wpex_mobile_nav_borders', function( value ) { value.bind( function( newval ) { if ( newval ) { $( '.wpex-mobile-nav-ul li a' ).css('border-color', newval ); } else { $( '.wpex-mobile-nav-ul li a' ).css('border-color', ''); } } ); } ); wp.customize( 'wpex_post_link_color', function( value ) { value.bind( function( newval ) { if ( newval ) { $( '.single .entry a, p.logged-in-as a, .comment-navigation a, .page .entry a, .entry-footer a, .home-slider-caption-excerpt a, .post-meta a, .home-cat-entry-post-other a, .home-cat-entry-post-other a:hover, .featured-carousel-slide a:hover, .related-carousel-slide a:hover, .next-prev a:hover' ).css('color', newval ); } else { $( '.single .entry a, p.logged-in-as a, .comment-navigation a, .page .entry a, .entry-footer a, .home-slider-caption-excerpt a, .post-meta a, .home-cat-entry-post-other a, .home-cat-entry-post-other a:hover, .featured-carousel-slide a:hover, .related-carousel-slide a:hover, .next-prev a:hover' ).css('color', ''); } } ); } ); wp.customize( 'wpex_sidebar_link_color', function( value ) { value.bind( function( newval ) { if ( newval ) { $( '.sidebar-container a' ).css('color', newval ); } else { $( '.sidebar-container a' ).css('color', ''); } } ); } ); wp.customize( 'wpex_readmore_color', function( value ) { value.bind( function( newval ) { if ( newval ) { $( '.loop-entry .wpex-readmore a, .home-slider-caption-excerpt .wpex-readmore a' ).css('color', newval ); } else { $( '.loop-entry .wpex-readmore a, .home-slider-caption-excerpt .wpex-readmore a' ).css('color', ''); } } ); } ); wp.customize( 'wpex_sidebar_title_color', function( value ) { value.bind( function( newval ) { if ( newval ) { $( '.sidebar-container .widget-title' ).css('color', newval ); } else { $( '.sidebar-container .widget-title' ).css('color', ''); } } ); } ); wp.customize( 'wpex_sidebar_title_border_color', function( value ) { value.bind( function( newval ) { if ( newval ) { $( '.sidebar-container .widget-title' ).css('border-color', newval ); } else { $( '.sidebar-container .widget-title' ).css('border-color', ''); } } ); } ); wp.customize( 'wpex_tag_cloud_color', function( value ) { value.bind( function( newval ) { if ( newval ) { $( '.widget_tag_cloud a, #wpex-widget-tags-tab a' ).css('color', newval ); } else { $( '.widget_tag_cloud a, #wpex-widget-tags-tab a' ).css('color', ''); } } ); } ); wp.customize( 'wpex_tag_cloud_bg', function( value ) { value.bind( function( newval ) { if ( newval ) { $( '.widget_tag_cloud a, #wpex-widget-tags-tab a' ).css('background-color', newval ); } else { $( '.widget_tag_cloud a, #wpex-widget-tags-tab a' ).css('background-color', ''); } } ); } ); wp.customize( 'wpex_tab_widget_active_color', function( value ) { value.bind( function( newval ) { if ( newval ) { $( '.wpex-tabs-widget-tabs a.active' ).css('border-top-color', newval ); } else { $( '.wpex-tabs-widget-tabs a.active' ).css('border-top-color', ''); } } ); } ); wp.customize( 'wpex_widget_search_submit_color', function( value ) { value.bind( function( newval ) { if ( newval ) { $( '.site-searchform button' ).css('color', newval ); } else { $( '.site-searchform button' ).css('color', ''); } } ); } ); wp.customize( 'wpex_widget_search_submit_bg', function( value ) { value.bind( function( newval ) { if ( newval ) { $( '.site-searchform button' ).css('background-color', newval ); } else { $( '.site-searchform button' ).css('background-color', ''); } } ); } ); wp.customize( 'wpex_theme_button_color', function( value ) { value.bind( function( newval ) { if ( newval ) { $( 'input[type="button"], input[type="submit"], .page-numbers a:hover, .page-numbers.current, .page-links span, .page-links a:hover span, .home-slider-caption-excerpt .wpex-readmore a, .loop-entry .wpex-readmore a' ).css('color', newval ); } else { $( 'input[type="button"], input[type="submit"], .page-numbers a:hover, .page-numbers.current, .page-links span, .page-links a:hover span, .home-slider-caption-excerpt .wpex-readmore a, .loop-entry .wpex-readmore a' ).css('color', ''); } } ); } ); wp.customize( 'wpex_theme_button_bg', function( value ) { value.bind( function( newval ) { if ( newval ) { $( 'input[type="button"], input[type="submit"], .page-numbers a:hover, .page-numbers.current, .page-links span, .page-links a:hover span, .home-slider-caption-excerpt .wpex-readmore a, .loop-entry .wpex-readmore a' ).css('background-color', newval ); } else { $( 'input[type="button"], input[type="submit"], .page-numbers a:hover, .page-numbers.current, .page-links span, .page-links a:hover span, .home-slider-caption-excerpt .wpex-readmore a, .loop-entry .wpex-readmore a' ).css('background-color', ''); } } ); } ); wp.customize( 'wpex_footer_widgets_bg', function( value ) { value.bind( function( newval ) { if ( newval ) { $( '#footer-wrap' ).css('background-color', newval ); } else { $( '#footer-wrap' ).css('background-color', ''); } } ); } ); wp.customize( 'wpex_footer_widgets_color', function( value ) { value.bind( function( newval ) { if ( newval ) { $( '#footer-wrap, #footer-wrap p' ).css('color', newval ); } else { $( '#footer-wrap, #footer-wrap p' ).css('color', ''); } } ); } ); wp.customize( 'wpex_footer_widgets_headings', function( value ) { value.bind( function( newval ) { if ( newval ) { $( '#footer-wrap h2, #footer-wrap h3, #footer-wrap h4, #footer-wrap h5, #footer-wrap h6, #footer-widgets .widget-title' ).css('color', newval ); } else { $( '#footer-wrap h2, #footer-wrap h3, #footer-wrap h4, #footer-wrap h5, #footer-wrap h6, #footer-widgets .widget-title' ).css('color', ''); } } ); } ); wp.customize( 'wpex_footer_widgets_links_color', function( value ) { value.bind( function( newval ) { if ( newval ) { $( '#footer-wrap a, #footer-widgets .widget_nav_menu ul > li li a:before' ).css('color', newval ); } else { $( '#footer-wrap a, #footer-widgets .widget_nav_menu ul > li li a:before' ).css('color', ''); } } ); } ); wp.customize( 'wpex_footer_widgets_borders', function( value ) { value.bind( function( newval ) { if ( newval ) { $( '#footer-widgets .widget_nav_menu ul > li, #footer-widgets .widget_nav_menu ul > li a, .footer-widget > ul > li:first-child, .footer-widget > ul > li, .footer-nav li:before, .wpex-tabs-widget-tab ul li' ).css('border-color', newval ); } else { $( '#footer-widgets .widget_nav_menu ul > li, #footer-widgets .widget_nav_menu ul > li a, .footer-widget > ul > li:first-child, .footer-widget > ul > li, .footer-nav li:before, .wpex-tabs-widget-tab ul li' ).css('border-color', ''); } } ); } ); wp.customize( 'wpex_footer_bottom_bg', function( value ) { value.bind( function( newval ) { if ( newval ) { $( '#footer-bottom' ).css('background-color', newval ); } else { $( '#footer-bottom' ).css('background-color', ''); } } ); } ); wp.customize( 'wpex_footer_bottom_color', function( value ) { value.bind( function( newval ) { if ( newval ) { $( '#footer-bottom, #footer-bottom p' ).css('color', newval ); } else { $( '#footer-bottom, #footer-bottom p' ).css('color', ''); } } ); } ); wp.customize( 'wpex_footer_bottom_links_color', function( value ) { value.bind( function( newval ) { if ( newval ) { $( '#footer-bottom a' ).css('color', newval ); } else { $( '#footer-bottom a' ).css('color', ''); } } ); } ); wp.customize( 'wpex_body_background', function( value ) { value.bind( function( newval ) { if ( newval ) { $( 'body' ).css('background-color', newval ); } else { $( 'body' ).css('background-color', ''); } } ); } ); wp.customize( 'wpex_author_comment_label_color', function( value ) { value.bind( function( newval ) { if ( newval ) { $( '.author-badge' ).css('color', newval ); } else { $( '.author-badge' ).css('color', ''); } } ); } ); wp.customize( 'wpex_author_comment_label_bg', function( value ) { value.bind( function( newval ) { if ( newval ) { $( '.author-badge' ).css('background-color', newval ); } else { $( '.author-badge' ).css('background-color', ''); } } ); } ); wp.customize( 'wpex_scrolltop_color', function( value ) { value.bind( function( newval ) { if ( newval ) { $( '.site-scroll-top' ).css('color', newval ); } else { $( '.site-scroll-top' ).css('color', ''); } } ); } ); wp.customize( 'wpex_scrolltop_bg', function( value ) { value.bind( function( newval ) { if ( newval ) { $( '.site-scroll-top' ).css('background-color', newval ); } else { $( '.site-scroll-top' ).css('background-color', ''); } } ); } );
		// Typography Options
		wp.customize("wpex_body_typography[font-weight]",function(t){$currentVal=$("body").css("font-weight"),t.bind(function(t){t?$("body").css("font-weight",t):$("body").css("font-weight","")})}),wp.customize("wpex_body_typography[font-style]",function(t){$currentVal=$("body").css("font-style"),t.bind(function(t){t?$("body").css("font-style",t):$("body").css("font-style","")})}),wp.customize("wpex_body_typography[font-size]",function(t){$currentVal=$("body").css("font-size"),t.bind(function(t){t?$("body").css("font-size",parseInt(t,10)+"px"):$("body").css("font-size","")})}),wp.customize("wpex_body_typography[color]",function(t){$currentVal=$("body").css("color"),t.bind(function(t){t?$("body").css("color",t):$("body").css("color","")})}),wp.customize("wpex_body_typography[line-height]",function(t){$currentVal=$("body").css("line-height"),t.bind(function(t){t?$("body").css("line-height",t):$("body").css("line-height","")})}),wp.customize("wpex_body_typography[letter-spacing]",function(t){$currentVal=$("body").css("letter-spacing"),t.bind(function(t){t?$("body").css("letter-spacing",parseInt(t,10)+"px"):$("body").css("letter-spacing","")})}),wp.customize("wpex_body_typography[text-transform]",function(t){$currentVal=$("body").css("text-transform"),t.bind(function(t){t?$("body").css("text-transform",t):$("body").css("text-transform","")})}),wp.customize("wpex_logo_typography[font-weight]",function(t){$currentVal=$(".site-text-logo a").css("font-weight"),t.bind(function(t){t?$(".site-text-logo a").css("font-weight",t):$(".site-text-logo a").css("font-weight","")})}),wp.customize("wpex_logo_typography[font-style]",function(t){$currentVal=$(".site-text-logo a").css("font-style"),t.bind(function(t){t?$(".site-text-logo a").css("font-style",t):$(".site-text-logo a").css("font-style","")})}),wp.customize("wpex_logo_typography[font-size]",function(t){$currentVal=$(".site-text-logo a").css("font-size"),t.bind(function(t){t?$(".site-text-logo a").css("font-size",parseInt(t,10)+"px"):$(".site-text-logo a").css("font-size","")})}),wp.customize("wpex_logo_typography[color]",function(t){$currentVal=$(".site-text-logo a").css("color"),t.bind(function(t){t?$(".site-text-logo a").css("color",t):$(".site-text-logo a").css("color","")})}),wp.customize("wpex_logo_typography[line-height]",function(t){$currentVal=$(".site-text-logo a").css("line-height"),t.bind(function(t){t?$(".site-text-logo a").css("line-height",t):$(".site-text-logo a").css("line-height","")})}),wp.customize("wpex_logo_typography[letter-spacing]",function(t){$currentVal=$(".site-text-logo a").css("letter-spacing"),t.bind(function(t){t?$(".site-text-logo a").css("letter-spacing",parseInt(t,10)+"px"):$(".site-text-logo a").css("letter-spacing","")})}),wp.customize("wpex_logo_typography[text-transform]",function(t){$currentVal=$(".site-text-logo a").css("text-transform"),t.bind(function(t){t?$(".site-text-logo a").css("text-transform",t):$(".site-text-logo a").css("text-transform","")})}),wp.customize("wpex_blog_description_typography[font-weight]",function(t){$currentVal=$("#blog-description").css("font-weight"),t.bind(function(t){t?$("#blog-description").css("font-weight",t):$("#blog-description").css("font-weight","")})}),wp.customize("wpex_blog_description_typography[font-style]",function(t){$currentVal=$("#blog-description").css("font-style"),t.bind(function(t){t?$("#blog-description").css("font-style",t):$("#blog-description").css("font-style","")})}),wp.customize("wpex_blog_description_typography[font-size]",function(t){$currentVal=$("#blog-description").css("font-size"),t.bind(function(t){t?$("#blog-description").css("font-size",parseInt(t,10)+"px"):$("#blog-description").css("font-size","")})}),wp.customize("wpex_blog_description_typography[color]",function(t){$currentVal=$("#blog-description").css("color"),t.bind(function(t){t?$("#blog-description").css("color",t):$("#blog-description").css("color","")})}),wp.customize("wpex_blog_description_typography[line-height]",function(t){$currentVal=$("#blog-description").css("line-height"),t.bind(function(t){t?$("#blog-description").css("line-height",t):$("#blog-description").css("line-height","")})}),wp.customize("wpex_blog_description_typography[letter-spacing]",function(t){$currentVal=$("#blog-description").css("letter-spacing"),t.bind(function(t){t?$("#blog-description").css("letter-spacing",parseInt(t,10)+"px"):$("#blog-description").css("letter-spacing","")})}),wp.customize("wpex_blog_description_typography[text-transform]",function(t){$currentVal=$("#blog-description").css("text-transform"),t.bind(function(t){t?$("#blog-description").css("text-transform",t):$("#blog-description").css("text-transform","")})}),wp.customize("wpex_top_menu_typography[font-weight]",function(t){$currentVal=$("#topbar-nav .sf-menu > li > a").css("font-weight"),t.bind(function(t){t?$("#topbar-nav .sf-menu > li > a").css("font-weight",t):$("#topbar-nav .sf-menu > li > a").css("font-weight","")})}),wp.customize("wpex_top_menu_typography[font-style]",function(t){$currentVal=$("#topbar-nav .sf-menu > li > a").css("font-style"),t.bind(function(t){t?$("#topbar-nav .sf-menu > li > a").css("font-style",t):$("#topbar-nav .sf-menu > li > a").css("font-style","")})}),wp.customize("wpex_top_menu_typography[font-size]",function(t){$currentVal=$("#topbar-nav .sf-menu > li > a").css("font-size"),t.bind(function(t){t?$("#topbar-nav .sf-menu > li > a").css("font-size",parseInt(t,10)+"px"):$("#topbar-nav .sf-menu > li > a").css("font-size","")})}),wp.customize("wpex_top_menu_typography[color]",function(t){$currentVal=$("#topbar-nav .sf-menu > li > a").css("color"),t.bind(function(t){t?$("#topbar-nav .sf-menu > li > a").css("color",t):$("#topbar-nav .sf-menu > li > a").css("color","")})}),wp.customize("wpex_top_menu_typography[line-height]",function(t){$currentVal=$("#topbar-nav .sf-menu > li > a").css("line-height"),t.bind(function(t){t?$("#topbar-nav .sf-menu > li > a").css("line-height",t):$("#topbar-nav .sf-menu > li > a").css("line-height","")})}),wp.customize("wpex_top_menu_typography[letter-spacing]",function(t){$currentVal=$("#topbar-nav .sf-menu > li > a").css("letter-spacing"),t.bind(function(t){t?$("#topbar-nav .sf-menu > li > a").css("letter-spacing",parseInt(t,10)+"px"):$("#topbar-nav .sf-menu > li > a").css("letter-spacing","")})}),wp.customize("wpex_top_menu_typography[text-transform]",function(t){$currentVal=$("#topbar-nav .sf-menu > li > a").css("text-transform"),t.bind(function(t){t?$("#topbar-nav .sf-menu > li > a").css("text-transform",t):$("#topbar-nav .sf-menu > li > a").css("text-transform","")})}),wp.customize("wpex_top_menu_dropdown_typography[font-weight]",function(t){$currentVal=$("#topbar-nav .sf-menu > li > ul > li a").css("font-weight"),t.bind(function(t){t?$("#topbar-nav .sf-menu > li > ul > li a").css("font-weight",t):$("#topbar-nav .sf-menu > li > ul > li a").css("font-weight","")})}),wp.customize("wpex_top_menu_dropdown_typography[font-style]",function(t){$currentVal=$("#topbar-nav .sf-menu > li > ul > li a").css("font-style"),t.bind(function(t){t?$("#topbar-nav .sf-menu > li > ul > li a").css("font-style",t):$("#topbar-nav .sf-menu > li > ul > li a").css("font-style","")})}),wp.customize("wpex_top_menu_dropdown_typography[font-size]",function(t){$currentVal=$("#topbar-nav .sf-menu > li > ul > li a").css("font-size"),t.bind(function(t){t?$("#topbar-nav .sf-menu > li > ul > li a").css("font-size",parseInt(t,10)+"px"):$("#topbar-nav .sf-menu > li > ul > li a").css("font-size","")})}),wp.customize("wpex_top_menu_dropdown_typography[color]",function(t){$currentVal=$("#topbar-nav .sf-menu > li > ul > li a").css("color"),t.bind(function(t){t?$("#topbar-nav .sf-menu > li > ul > li a").css("color",t):$("#topbar-nav .sf-menu > li > ul > li a").css("color","")})}),wp.customize("wpex_top_menu_dropdown_typography[line-height]",function(t){$currentVal=$("#topbar-nav .sf-menu > li > ul > li a").css("line-height"),t.bind(function(t){t?$("#topbar-nav .sf-menu > li > ul > li a").css("line-height",t):$("#topbar-nav .sf-menu > li > ul > li a").css("line-height","")})}),wp.customize("wpex_top_menu_dropdown_typography[letter-spacing]",function(t){$currentVal=$("#topbar-nav .sf-menu > li > ul > li a").css("letter-spacing"),t.bind(function(t){t?$("#topbar-nav .sf-menu > li > ul > li a").css("letter-spacing",parseInt(t,10)+"px"):$("#topbar-nav .sf-menu > li > ul > li a").css("letter-spacing","")})}),wp.customize("wpex_top_menu_dropdown_typography[text-transform]",function(t){$currentVal=$("#topbar-nav .sf-menu > li > ul > li a").css("text-transform"),t.bind(function(t){t?$("#topbar-nav .sf-menu > li > ul > li a").css("text-transform",t):$("#topbar-nav .sf-menu > li > ul > li a").css("text-transform","")})}),wp.customize("wpex_menu_typography[font-weight]",function(t){$currentVal=$("#site-navigation .sf-menu > li > a").css("font-weight"),t.bind(function(t){t?$("#site-navigation .sf-menu > li > a").css("font-weight",t):$("#site-navigation .sf-menu > li > a").css("font-weight","")})}),wp.customize("wpex_menu_typography[font-style]",function(t){$currentVal=$("#site-navigation .sf-menu > li > a").css("font-style"),t.bind(function(t){t?$("#site-navigation .sf-menu > li > a").css("font-style",t):$("#site-navigation .sf-menu > li > a").css("font-style","")})}),wp.customize("wpex_menu_typography[font-size]",function(t){$currentVal=$("#site-navigation .sf-menu > li > a").css("font-size"),t.bind(function(t){t?$("#site-navigation .sf-menu > li > a").css("font-size",parseInt(t,10)+"px"):$("#site-navigation .sf-menu > li > a").css("font-size","")})}),wp.customize("wpex_menu_typography[color]",function(t){$currentVal=$("#site-navigation .sf-menu > li > a").css("color"),t.bind(function(t){t?$("#site-navigation .sf-menu > li > a").css("color",t):$("#site-navigation .sf-menu > li > a").css("color","")})}),wp.customize("wpex_menu_typography[line-height]",function(t){$currentVal=$("#site-navigation .sf-menu > li > a").css("line-height"),t.bind(function(t){t?$("#site-navigation .sf-menu > li > a").css("line-height",t):$("#site-navigation .sf-menu > li > a").css("line-height","")})}),wp.customize("wpex_menu_typography[letter-spacing]",function(t){$currentVal=$("#site-navigation .sf-menu > li > a").css("letter-spacing"),t.bind(function(t){t?$("#site-navigation .sf-menu > li > a").css("letter-spacing",parseInt(t,10)+"px"):$("#site-navigation .sf-menu > li > a").css("letter-spacing","")})}),wp.customize("wpex_menu_typography[text-transform]",function(t){$currentVal=$("#site-navigation .sf-menu > li > a").css("text-transform"),t.bind(function(t){t?$("#site-navigation .sf-menu > li > a").css("text-transform",t):$("#site-navigation .sf-menu > li > a").css("text-transform","")})}),wp.customize("wpex_menu_dropdown_typography[font-weight]",function(t){$currentVal=$("#site-navigation .sf-menu > li > ul li a").css("font-weight"),t.bind(function(t){t?$("#site-navigation .sf-menu > li > ul li a").css("font-weight",t):$("#site-navigation .sf-menu > li > ul li a").css("font-weight","")})}),wp.customize("wpex_menu_dropdown_typography[font-style]",function(t){$currentVal=$("#site-navigation .sf-menu > li > ul li a").css("font-style"),t.bind(function(t){t?$("#site-navigation .sf-menu > li > ul li a").css("font-style",t):$("#site-navigation .sf-menu > li > ul li a").css("font-style","")})}),wp.customize("wpex_menu_dropdown_typography[font-size]",function(t){$currentVal=$("#site-navigation .sf-menu > li > ul li a").css("font-size"),t.bind(function(t){t?$("#site-navigation .sf-menu > li > ul li a").css("font-size",parseInt(t,10)+"px"):$("#site-navigation .sf-menu > li > ul li a").css("font-size","")})}),wp.customize("wpex_menu_dropdown_typography[color]",function(t){$currentVal=$("#site-navigation .sf-menu > li > ul li a").css("color"),t.bind(function(t){t?$("#site-navigation .sf-menu > li > ul li a").css("color",t):$("#site-navigation .sf-menu > li > ul li a").css("color","")})}),wp.customize("wpex_menu_dropdown_typography[line-height]",function(t){$currentVal=$("#site-navigation .sf-menu > li > ul li a").css("line-height"),t.bind(function(t){t?$("#site-navigation .sf-menu > li > ul li a").css("line-height",t):$("#site-navigation .sf-menu > li > ul li a").css("line-height","")})}),wp.customize("wpex_menu_dropdown_typography[letter-spacing]",function(t){$currentVal=$("#site-navigation .sf-menu > li > ul li a").css("letter-spacing"),t.bind(function(t){t?$("#site-navigation .sf-menu > li > ul li a").css("letter-spacing",parseInt(t,10)+"px"):$("#site-navigation .sf-menu > li > ul li a").css("letter-spacing","")})}),wp.customize("wpex_menu_dropdown_typography[text-transform]",function(t){$currentVal=$("#site-navigation .sf-menu > li > ul li a").css("text-transform"),t.bind(function(t){t?$("#site-navigation .sf-menu > li > ul li a").css("text-transform",t):$("#site-navigation .sf-menu > li > ul li a").css("text-transform","")})}),wp.customize("wpex_page_header_typography[font-weight]",function(t){$currentVal=$(".post-header-title").css("font-weight"),t.bind(function(t){t?$(".post-header-title").css("font-weight",t):$(".post-header-title").css("font-weight","")})}),wp.customize("wpex_page_header_typography[font-style]",function(t){$currentVal=$(".post-header-title").css("font-style"),t.bind(function(t){t?$(".post-header-title").css("font-style",t):$(".post-header-title").css("font-style","")})}),wp.customize("wpex_page_header_typography[font-size]",function(t){$currentVal=$(".post-header-title").css("font-size"),t.bind(function(t){t?$(".post-header-title").css("font-size",parseInt(t,10)+"px"):$(".post-header-title").css("font-size","")})}),wp.customize("wpex_page_header_typography[color]",function(t){$currentVal=$(".post-header-title").css("color"),t.bind(function(t){t?$(".post-header-title").css("color",t):$(".post-header-title").css("color","")})}),wp.customize("wpex_page_header_typography[line-height]",function(t){$currentVal=$(".post-header-title").css("line-height"),t.bind(function(t){t?$(".post-header-title").css("line-height",t):$(".post-header-title").css("line-height","")})}),wp.customize("wpex_page_header_typography[letter-spacing]",function(t){$currentVal=$(".post-header-title").css("letter-spacing"),t.bind(function(t){t?$(".post-header-title").css("letter-spacing",parseInt(t,10)+"px"):$(".post-header-title").css("letter-spacing","")})}),wp.customize("wpex_page_header_typography[text-transform]",function(t){$currentVal=$(".post-header-title").css("text-transform"),t.bind(function(t){t?$(".post-header-title").css("text-transform",t):$(".post-header-title").css("text-transform","")})}),wp.customize("wpex_post_tile_typography[font-weight]",function(t){$currentVal=$(".loop-entry-title").css("font-weight"),t.bind(function(t){t?$(".loop-entry-title").css("font-weight",t):$(".loop-entry-title").css("font-weight","")})}),wp.customize("wpex_post_tile_typography[font-style]",function(t){$currentVal=$(".loop-entry-title").css("font-style"),t.bind(function(t){t?$(".loop-entry-title").css("font-style",t):$(".loop-entry-title").css("font-style","")})}),wp.customize("wpex_post_tile_typography[font-size]",function(t){$currentVal=$(".loop-entry-title").css("font-size"),t.bind(function(t){t?$(".loop-entry-title").css("font-size",parseInt(t,10)+"px"):$(".loop-entry-title").css("font-size","")})}),wp.customize("wpex_post_tile_typography[color]",function(t){$currentVal=$(".loop-entry-title").css("color"),t.bind(function(t){t?$(".loop-entry-title").css("color",t):$(".loop-entry-title").css("color","")})}),wp.customize("wpex_post_tile_typography[line-height]",function(t){$currentVal=$(".loop-entry-title").css("line-height"),t.bind(function(t){t?$(".loop-entry-title").css("line-height",t):$(".loop-entry-title").css("line-height","")})}),wp.customize("wpex_post_tile_typography[letter-spacing]",function(t){$currentVal=$(".loop-entry-title").css("letter-spacing"),t.bind(function(t){t?$(".loop-entry-title").css("letter-spacing",parseInt(t,10)+"px"):$(".loop-entry-title").css("letter-spacing","")})}),wp.customize("wpex_post_tile_typography[text-transform]",function(t){$currentVal=$(".loop-entry-title").css("text-transform"),t.bind(function(t){t?$(".loop-entry-title").css("text-transform",t):$(".loop-entry-title").css("text-transform","")})}),wp.customize("wpex_page_title_typography[font-weight]",function(t){$currentVal=$(".page-header-title").css("font-weight"),t.bind(function(t){t?$(".page-header-title").css("font-weight",t):$(".page-header-title").css("font-weight","")})}),wp.customize("wpex_page_title_typography[font-style]",function(t){$currentVal=$(".page-header-title").css("font-style"),t.bind(function(t){t?$(".page-header-title").css("font-style",t):$(".page-header-title").css("font-style","")})}),wp.customize("wpex_page_title_typography[font-size]",function(t){$currentVal=$(".page-header-title").css("font-size"),t.bind(function(t){t?$(".page-header-title").css("font-size",parseInt(t,10)+"px"):$(".page-header-title").css("font-size","")})}),wp.customize("wpex_page_title_typography[color]",function(t){$currentVal=$(".page-header-title").css("color"),t.bind(function(t){t?$(".page-header-title").css("color",t):$(".page-header-title").css("color","")})}),wp.customize("wpex_page_title_typography[line-height]",function(t){$currentVal=$(".page-header-title").css("line-height"),t.bind(function(t){t?$(".page-header-title").css("line-height",t):$(".page-header-title").css("line-height","")})}),wp.customize("wpex_page_title_typography[letter-spacing]",function(t){$currentVal=$(".page-header-title").css("letter-spacing"),t.bind(function(t){t?$(".page-header-title").css("letter-spacing",parseInt(t,10)+"px"):$(".page-header-title").css("letter-spacing","")})}),wp.customize("wpex_page_title_typography[text-transform]",function(t){$currentVal=$(".page-header-title").css("text-transform"),t.bind(function(t){t?$(".page-header-title").css("text-transform",t):$(".page-header-title").css("text-transform","")})}),wp.customize("wpex_sidebar_widget_title_typography[font-weight]",function(t){$currentVal=$(".sidebar-widget .widget-title").css("font-weight"),t.bind(function(t){t?$(".sidebar-widget .widget-title").css("font-weight",t):$(".sidebar-widget .widget-title").css("font-weight","")})}),wp.customize("wpex_sidebar_widget_title_typography[font-style]",function(t){$currentVal=$(".sidebar-widget .widget-title").css("font-style"),t.bind(function(t){t?$(".sidebar-widget .widget-title").css("font-style",t):$(".sidebar-widget .widget-title").css("font-style","")})}),wp.customize("wpex_sidebar_widget_title_typography[font-size]",function(t){$currentVal=$(".sidebar-widget .widget-title").css("font-size"),t.bind(function(t){t?$(".sidebar-widget .widget-title").css("font-size",parseInt(t,10)+"px"):$(".sidebar-widget .widget-title").css("font-size","")})}),wp.customize("wpex_sidebar_widget_title_typography[color]",function(t){$currentVal=$(".sidebar-widget .widget-title").css("color"),t.bind(function(t){t?$(".sidebar-widget .widget-title").css("color",t):$(".sidebar-widget .widget-title").css("color","")})}),wp.customize("wpex_sidebar_widget_title_typography[line-height]",function(t){$currentVal=$(".sidebar-widget .widget-title").css("line-height"),t.bind(function(t){t?$(".sidebar-widget .widget-title").css("line-height",t):$(".sidebar-widget .widget-title").css("line-height","")})}),wp.customize("wpex_sidebar_widget_title_typography[letter-spacing]",function(t){$currentVal=$(".sidebar-widget .widget-title").css("letter-spacing"),t.bind(function(t){t?$(".sidebar-widget .widget-title").css("letter-spacing",parseInt(t,10)+"px"):$(".sidebar-widget .widget-title").css("letter-spacing","")})}),wp.customize("wpex_sidebar_widget_title_typography[text-transform]",function(t){$currentVal=$(".sidebar-widget .widget-title").css("text-transform"),t.bind(function(t){t?$(".sidebar-widget .widget-title").css("text-transform",t):$(".sidebar-widget .widget-title").css("text-transform","")})}),wp.customize("wpex_footer_widget_title_typography[font-weight]",function(t){$currentVal=$(".footer-widget .widget-title").css("font-weight"),t.bind(function(t){t?$(".footer-widget .widget-title").css("font-weight",t):$(".footer-widget .widget-title").css("font-weight","")})}),wp.customize("wpex_footer_widget_title_typography[font-style]",function(t){$currentVal=$(".footer-widget .widget-title").css("font-style"),t.bind(function(t){t?$(".footer-widget .widget-title").css("font-style",t):$(".footer-widget .widget-title").css("font-style","")})}),wp.customize("wpex_footer_widget_title_typography[font-size]",function(t){$currentVal=$(".footer-widget .widget-title").css("font-size"),t.bind(function(t){t?$(".footer-widget .widget-title").css("font-size",parseInt(t,10)+"px"):$(".footer-widget .widget-title").css("font-size","")})}),wp.customize("wpex_footer_widget_title_typography[color]",function(t){$currentVal=$(".footer-widget .widget-title").css("color"),t.bind(function(t){t?$(".footer-widget .widget-title").css("color",t):$(".footer-widget .widget-title").css("color","")})}),wp.customize("wpex_footer_widget_title_typography[line-height]",function(t){$currentVal=$(".footer-widget .widget-title").css("line-height"),t.bind(function(t){t?$(".footer-widget .widget-title").css("line-height",t):$(".footer-widget .widget-title").css("line-height","")})}),wp.customize("wpex_footer_widget_title_typography[letter-spacing]",function(t){$currentVal=$(".footer-widget .widget-title").css("letter-spacing"),t.bind(function(t){t?$(".footer-widget .widget-title").css("letter-spacing",parseInt(t,10)+"px"):$(".footer-widget .widget-title").css("letter-spacing","")})}),wp.customize("wpex_footer_widget_title_typography[text-transform]",function(t){$currentVal=$(".footer-widget .widget-title").css("text-transform"),t.bind(function(t){t?$(".footer-widget .widget-title").css("text-transform",t):$(".footer-widget .widget-title").css("text-transform","")})}),wp.customize("wpex_entry_h2_typography[font-weight]",function(t){$currentVal=$(".entry h2").css("font-weight"),t.bind(function(t){t?$(".entry h2").css("font-weight",t):$(".entry h2").css("font-weight","")})}),wp.customize("wpex_entry_h2_typography[font-style]",function(t){$currentVal=$(".entry h2").css("font-style"),t.bind(function(t){t?$(".entry h2").css("font-style",t):$(".entry h2").css("font-style","")})}),wp.customize("wpex_entry_h2_typography[font-size]",function(t){$currentVal=$(".entry h2").css("font-size"),t.bind(function(t){t?$(".entry h2").css("font-size",parseInt(t,10)+"px"):$(".entry h2").css("font-size","")})}),wp.customize("wpex_entry_h2_typography[color]",function(t){$currentVal=$(".entry h2").css("color"),t.bind(function(t){t?$(".entry h2").css("color",t):$(".entry h2").css("color","")})}),wp.customize("wpex_entry_h2_typography[line-height]",function(t){$currentVal=$(".entry h2").css("line-height"),t.bind(function(t){t?$(".entry h2").css("line-height",t):$(".entry h2").css("line-height","")})}),wp.customize("wpex_entry_h2_typography[letter-spacing]",function(t){$currentVal=$(".entry h2").css("letter-spacing"),t.bind(function(t){t?$(".entry h2").css("letter-spacing",parseInt(t,10)+"px"):$(".entry h2").css("letter-spacing","")})}),wp.customize("wpex_entry_h2_typography[text-transform]",function(t){$currentVal=$(".entry h2").css("text-transform"),t.bind(function(t){t?$(".entry h2").css("text-transform",t):$(".entry h2").css("text-transform","")})}),wp.customize("wpex_entry_h3_typography[font-weight]",function(t){$currentVal=$(".entry h3").css("font-weight"),t.bind(function(t){t?$(".entry h3").css("font-weight",t):$(".entry h3").css("font-weight","")})}),wp.customize("wpex_entry_h3_typography[font-style]",function(t){$currentVal=$(".entry h3").css("font-style"),t.bind(function(t){t?$(".entry h3").css("font-style",t):$(".entry h3").css("font-style","")})}),wp.customize("wpex_entry_h3_typography[font-size]",function(t){$currentVal=$(".entry h3").css("font-size"),t.bind(function(t){t?$(".entry h3").css("font-size",parseInt(t,10)+"px"):$(".entry h3").css("font-size","")})}),wp.customize("wpex_entry_h3_typography[color]",function(t){$currentVal=$(".entry h3").css("color"),t.bind(function(t){t?$(".entry h3").css("color",t):$(".entry h3").css("color","")})}),wp.customize("wpex_entry_h3_typography[line-height]",function(t){$currentVal=$(".entry h3").css("line-height"),t.bind(function(t){t?$(".entry h3").css("line-height",t):$(".entry h3").css("line-height","")})}),wp.customize("wpex_entry_h3_typography[letter-spacing]",function(t){$currentVal=$(".entry h3").css("letter-spacing"),t.bind(function(t){t?$(".entry h3").css("letter-spacing",parseInt(t,10)+"px"):$(".entry h3").css("letter-spacing","")})}),wp.customize("wpex_entry_h3_typography[text-transform]",function(t){$currentVal=$(".entry h3").css("text-transform"),t.bind(function(t){t?$(".entry h3").css("text-transform",t):$(".entry h3").css("text-transform","")})});
} )( jQuery );