<?php
/**
 * Customizer main functions and includes
 *
 * @package		Spartan
 * @subpackage	Customizer
 * @author		Alexander Clarke
 * @copyright	Copyright (c) 2014, Symple Workz LLC
 * @link		http://www.wpexplorer.com
 * @since		Spartan 1.0.0
 */

/**
 * Binds JS handlers to make Theme Customizer preview reload changes asynchronously.
 *
 * @since 1.0.2
 */
if( ! function_exists( 'wpex_customize_preview_js' ) ) {
	function wpex_customize_preview_js() {
		wp_enqueue_script( 'wpex-customizer', get_template_directory_uri() . '/functions/customizer/assets/customizer-postmessage.js', array( 'customize-preview' ), '1.0.2', true );
		
	}
}
add_action( 'customize_preview_init', 'wpex_customize_preview_js' );

/**
 * Loads customizer css file for the WordPress customizer
 *
 * @since 1.0.2
 */
if( ! function_exists( 'wpex_customize_preview_css' ) ) {
	function wpex_customize_preview_css() {
		wp_enqueue_style( 'wpex-customizer', get_template_directory_uri() . '/functions/customizer/assets/customizer-style.css', '1.0' );
	}
}
add_action( 'customize_controls_print_styles', 'wpex_customize_preview_css' );

/**
 * Add postMessage support for site title and description for the Theme Customizer.
 *
 * @since 1.0
 * @param WP_Customize_Manager $wp_customize Theme Customizer object.
 */
if( ! function_exists( 'wpex_customize_register' ) ) {
	function wpex_customize_register( $wp_customize ) {
		$wp_customize->get_setting( 'blogname' )->transport			= 'postMessage';
		$wp_customize->get_setting( 'blogdescription' )->transport	= 'postMessage';
	}
}
add_action( 'customize_register', 'wpex_customize_register' );

/**
 * Include customizer functions and panels
 *
 * @since 1.0.2
 */
require_once ( get_template_directory() .'/functions/customizer/admin.php' );
require_once ( get_template_directory() .'/functions/customizer/controls.php' );
require_once ( get_template_directory() .'/functions/customizer/fonts.php' );
require_once ( get_template_directory() .'/functions/customizer/panels/general.php' );
require_once ( get_template_directory() .'/functions/customizer/panels/styling.php' );
require_once ( get_template_directory() .'/functions/customizer/panels/typography.php' );
require_once ( get_template_directory() .'/functions/customizer/panels/homepage.php' );
require_once ( get_template_directory() .'/functions/customizer/panels/image-sizes.php' );
require_once ( get_template_directory() .'/functions/customizer/helpers/js-generator.php' );