<?php
/**
 * Outputs your custom CSS to the front of the site.
 *
 * @package		Spartan
 * @subpackage	Customizer
 * @author		Alexander Clarke
 * @copyright	Copyright (c) 2014, Symple Workz LLC
 * @link		http://www.wpexplorer.com
 * @since		Spartan 1.0.2
 */

// Only needed for the front end
if ( is_admin() ) {
	return;
}

// Outputs the custom CSS to the head tag
if ( ! function_exists( 'wpex_output_custom_css' ) ) {
	function wpex_output_custom_css() {
		if ( $css = get_option( 'wpex_custom_css' ) ) {
			echo "<!-- Custom CSS -->\n<style type=\"text/css\">\n" . $css . "\n</style>";
		}
	}
}
add_action( 'wp_head', 'wpex_output_custom_css' );