<?php
/**
 * Creates the admin panel for the customizer
 *
 * @package		Spartan
 * @subpackage	Customizer
 * @author		Alexander Clarke
 * @copyright	Copyright (c) 2014, Symple Workz LLC
 * @link		http://www.wpexplorer.com
 * @since		Spartan 1.0.2
 */

// Only Needed in the admin
if ( ! is_admin() ) {
	return;
}

// Exit if accessed directly
if ( ! defined( 'ABSPATH' ) ) {
	exit;
}

/**
 * Add sub menu page to the Appearance menu.
 *
 * @link http://codex.wordpress.org/Function_Reference/add_theme_page
 */
if ( ! function_exists( 'wpex_custom_css_admin' ) ) {
	function wpex_custom_css_admin() {
		add_submenu_page( 'themes.php', __( 'Custom CSS', 'wpex' ),  __( 'Custom CSS', 'wpex' ), 'administrator', 'wpex-custom-css-admin', 'wpex_custom_css_page' );
	}
}
add_action( 'admin_menu', 'wpex_custom_css_admin' );

/**
 * Load scripts
 *
 * @link http://codex.wordpress.org/Plugin_API/Action_Reference/admin_enqueue_scripts
 */
if ( ! function_exists( 'wpex_custom_css_admin_scripts' ) ) {
	function wpex_custom_css_admin_scripts( $hook ) {
		if ( $hook == 'appearance_page_wpex-custom-css-admin' ) {
			$dir = get_template_directory_uri() .'/functions/custom-css/assets/';
			wp_enqueue_script( 'wpex-codemirror', $dir . 'codemirror.js', array( 'jquery' ) );
			wp_enqueue_script( 'wpex-codemirror-css', $dir . 'css.js', array( 'jquery', 'wpex-codemirror' ) );
			wp_enqueue_script( 'wpex-codemirror-css-link', $dir . 'css-lint.js', array( 'jquery', 'wpex-codemirror', 'wpex-codemirror-css' ) );
			wp_enqueue_style( 'wpex-codemirror', $dir . 'codemirror.css' );
			if ( 'dark' == get_option( 'wpex_custom_css_theme', 'dark' ) ) {
				wp_enqueue_style( 'wpex-codemirror-theme', $dir . 'theme-dark.css' );
			} else {
				wp_enqueue_style( 'wpex-codemirror-theme', $dir . 'theme-light.css' );
			}
		}
	}
}
add_action( 'admin_enqueue_scripts', 'wpex_custom_css_admin_scripts' );

/**
 * Register a setting and its sanitization callback.
 *
 * @link http://codex.wordpress.org/Function_Reference/register_setting
 */
if ( ! function_exists( 'wpex_custom_css_register_settings' ) ) {
	function wpex_custom_css_register_settings() {
		register_setting( 'wpex_custom_css', 'wpex_custom_css', 'wpex_custom_css_sanitize' );
		register_setting( 'wpex_custom_css', 'wpex_custom_css_theme' );
	}
}
add_action( 'admin_init', 'wpex_custom_css_register_settings' );

/**
 * Displays all messages registered to 'wpex-custom_css-notices'
 *
 * @link http://codex.wordpress.org/Function_Reference/settings_errors
 */
if ( ! function_exists( 'wpex_custom_css_admin_notices_action' ) ) {
	function wpex_custom_css_admin_notices_action() {
		settings_errors( 'wpex-custom_css-notices' );
	}
}
add_action( 'admin_notices', 'wpex_custom_css_admin_notices_action' );

/**
 * Sanitization callback
 */
if ( ! function_exists( 'wpex_custom_css_sanitize' ) ) {
	function wpex_custom_css_sanitize( $option ) {
		add_settings_error(
			'wpex-custom_css-notices',
			esc_attr( 'settings_updated' ),
			__( 'Your custom CSS was saved successfully', 'wpex' ),
			'updated'
		);
		return $option;
	}
}

/**
 * Settings page output
 */
if ( ! function_exists( 'wpex_custom_css_page' ) ) {
	function wpex_custom_css_page() { ?>
		<div class="wrap">
			<h2 style="padding-right:0;">
				<?php _e( 'Custom CSS', 'wpex' ); ?>
				<p><?php _e( 'Use this page to make design tweaks to your theme if you don\'t want to use a child theme. All custom CSS will be output to the Head tag of the site.', 'wpex' ); ?></p>
			</h2>
			<div style="margin:10px 0 20px;"><a href="#" class="button-secondary wpex-custom-css-toggle-skin"><?php _e( 'Toggle Skin', 'wpex' ); ?></a></div>
			<form method="post" action="options.php">
				<?php
				/**
				 * Output nonce, action, and option_page fields for a settings page
				 *
				 * @link http://codex.wordpress.org/Function_Reference/settings_fields
				 */
				$option = get_option( 'wpex_custom_css' );
				settings_fields( 'wpex_custom_css' ); ?>
				<table class="form-table">
					<tr valign="top">
						<td style="padding:0;">
							<textarea rows="40" cols="50" id="wpex_custom_css" style="width:100%;" name="wpex_custom_css"><?php echo $option; ?></textarea>
						</td>
					</tr>
				</table>
				<input type="hidden" name="wpex_custom_css_theme" value="<?php echo get_option( 'wpex_custom_css_theme', 'dark' ); ?>" id="wpex-default-codemirror-theme"></input>
				<p class="submit">
					<input type="submit" class="button-primary wpex-submit-form" value="<?php _e( 'Save CSS', 'wpex' ) ?>" />
				</p>
			</form>
		</div>
		<script>
			(function($) {
				"use strict";
					window.onload = function() {
						window.editor = CodeMirror.fromTextArea(wpex_custom_css, {
							mode: "css",
							lineNumbers: true,
							lineWrapping: true,
							theme: 'wpex',
							lint: true
						});
					};
					<?php $dir = get_template_directory_uri() .'/functions/custom-css/assets/'; ?>
					$('.wpex-custom-css-toggle-skin').click(function() {
						var hiddenField = $('#wpex-default-codemirror-theme');
						if ( hiddenField.val() == 'dark' ) {
							hiddenField.val('light');
							$('#wpex-codemirror-theme-css').attr('href','<?php echo $dir; ?>theme-light.css');
						} else {
							hiddenField.val('dark');
							$('#wpex-codemirror-theme-css').attr('href','<?php echo $dir; ?>theme-dark.css');
						}
						return false;
					});
			})(jQuery);
		</script>
	<?php }
}