<?php
/**
 * Adds classes to the body tag for various page/post layout styles
 *
 * @package WordPress
 * @subpackage Total
 * @since Total 1.0
*/

if ( !function_exists( 'wpex_body_classes' ) ) {
	function wpex_body_classes( $classes ) {

		global $post;
		$is_mobile = wp_is_mobile();
		
		// WPExplorer class
		$classes[] = 'wpex-theme';

		// Mobile
		if ( '1' == $is_mobile ) {
			$classes[] = 'is-mobile';
		}

		// Layout Classes
		$classes[] = get_theme_mod( 'wpex_site_layout', 'right-sidebar' );

		// Fixed header
		if ( get_theme_mod( 'wpex_fixed_nav', '1' ) && ! $is_mobile ) {
			$classes[] = 'fixed-nav';
		}

		// Full-width Page
		if( is_page() && 'fullwidth' == get_post_meta( get_the_ID(), 'wpex_post_layout', true ) ) {
			$classes[] = 'fullwidth-post';
		}

		// RTL
		if( is_rtl() && ! in_array( 'rtl', $classes ) ) {
			$classes[] = 'rtl';
		}
		
		return $classes;
	}
}
add_filter( 'body_class', 'wpex_body_classes' );