<?php
/**
 * Theme functions and definitions.
 *
 * Sets up the theme and provides some helper functions
 *
 * When using a child theme (see http://codex.wordpress.org/Theme_Development
 * and http://codex.wordpress.org/Child_Themes), you can override certain
 * functions (those wrapped in a function_exists() call) by defining them first
 * in your child theme's functions.php file. The child theme's functions.php
 * file is included before the parent theme's file, so the child theme
 * functions would be used.
 *
 *
 * For more information on hooks, actions, and filters,
 * see http://codex.wordpress.org/Plugin_API
 *
 * @package WordPress
 * @subpackage Spartan WPExplorer Theme
 * @since Spartan 1.0
 */

/*-----------------------------------------------------------------------------------*/
/*	- Define Constants
/*-----------------------------------------------------------------------------------*/

// Main ccs/js directory
define( 'WPEX_CSS_DIR_URI', get_template_directory_uri().'/css/' );
define( 'WPEX_JS_DIR_URI', get_template_directory_uri().'/js/' );

// Theme branding
if ( !defined( 'wpex_theme_branding' ) ) {
	if ( get_theme_mod( 'wpex_theme_branding', 'Spartan' ) ) {
		define( 'WPEX_THEME_BRANDING', get_theme_mod( 'wpex_theme_branding', 'Spartan' ) );
	} else {
		define( 'WPEX_THEME_BRANDING', 'Spartan' );
	}
}

/*-----------------------------------------------------------------------------------*/
/*	- Theme Setup
/*-----------------------------------------------------------------------------------*/

// WP content width variable
if ( ! isset( $content_width ) ) {
	$content_width = 650;
}

// Theme setup - menus, theme support, etc
require_once( get_template_directory() .'/functions/theme-setup.php' );

// Recommend plugins for use with this theme
require_once ( get_template_directory() .'/functions/recommend-plugins.php' );

// Load theme customizer functions
require_once ( get_template_directory() .'/functions/customizer/customizer.php' );

/*-----------------------------------------------------------------------------------*/
/*	- Custom CSS
/*-----------------------------------------------------------------------------------*/

// Custom CSS admin
require_once ( get_template_directory() .'/functions/custom-css/admin.php' );

// Custom CSS output
require_once ( get_template_directory() .'/functions/custom-css/output.php' );

/*-----------------------------------------------------------------------------------*/
/*	- Include functions for backend-end only
/*-----------------------------------------------------------------------------------*/
if( is_admin() ) {

	// Post editor tweaks
	require_once( get_template_directory() .'/functions/mce.php' );

	// Gallery Metabox
	require_once( get_template_directory() .'/functions/meta/gallery-metabox/gmb-admin.php' );

	// Post dashboard thumbnails
	if( get_theme_mod( 'wpex_dashboard_thumbs', '1' ) ) {
		require_once( get_template_directory() .'/functions/dashboard-thumbs.php' );
	}

	// Default meta options usage
	require_once( get_template_directory() .'/functions/meta/usage.php' );

}

/*-----------------------------------------------------------------------------------*/
/*	- Include functions for front-end only
/*-----------------------------------------------------------------------------------*/

if( ! is_admin() ) {

	// Category Colors
	require_once ( get_template_directory() .'/functions/category-colors.php' );

	// Grid classes
	require_once( get_template_directory() .'/functions/grid.php' );

	// Pre Get Posts Tweaks
	require_once( get_template_directory() .'/functions/pre-get-posts.php' );

	// Adds classes to entries
	require_once( get_template_directory() .'/functions/post-classes.php' );

	// Important category functions
	require_once( get_template_directory() .'/functions/categories.php' );

	// Gallery Metabox
	require_once( get_template_directory() .'/functions/meta/gallery-metabox/gmb-display.php' );

	// Social Share
	require_once( get_template_directory() .'/functions/social-share.php' );

	// Outputs the main site logo
	require_once( get_template_directory() .'/functions/logo.php' );

	// Menu Walker
	require_once( get_template_directory() .'/functions/navs.php' );

	// Loads front end css and js
	require_once( get_template_directory() .'/functions/scripts.php' );

	// Fix for HTTPS
	require_once( get_template_directory() .'/functions/honor-ssl-for-attachments.php' );

	// Returns the correct image sizes for cropping
	require_once( get_template_directory() .'/functions/featured-image.php' );

	// Comments output
	require_once( get_template_directory() .'/functions/comments-callback.php' );

	// Outputs the footer copyright
	require_once( get_template_directory() .'/functions/copyright.php' );

	// Outputs the footer nav
	require_once( get_template_directory() .'/functions/footer-nav.php' );

	// Used for next/previous links on single posts
	require_once( get_template_directory() .'/functions/next-prev.php' );

	// Outputs post author bio
	require_once( get_template_directory() .'/functions/post-author.php' );

	// Outputs post slider
	require_once( get_template_directory() .'/functions/post-gallery.php' );

	// Custom WP Gallery Output
	if ( get_theme_mod( 'wpex_custom_wp_gallery_output', '1' ) ) {
		require_once( get_template_directory() .'/functions/wp-gallery.php' );
	}

	// Page featured images
	require_once( get_template_directory() .'/functions/page-featured-image.php' );

	// Entry featured images
	require_once( get_template_directory() .'/functions/entry-featured-image.php' );

	// Post featured images
	require_once( get_template_directory() .'/functions/post-featured-image.php' );

	// Scroll top link
	require_once( get_template_directory() .'/functions/scroll-top-link.php' );

	// Body Classes
	require_once( get_template_directory() .'/functions/body-classes.php' );

	// Related Posts For Single Posts
	require_once( get_template_directory() .'/functions/related-posts.php' );

	// Custom excerpts
	require_once( get_template_directory() .'/functions/excerpts.php' );

	// Outputs post meta (date, cat, comment count)
	require_once( get_template_directory() .'/functions/post-meta.php' );

	// Entry Overlay
	require_once( get_template_directory() .'/functions/entry-overlay.php' );

	// Outputs the post format video
	require_once( get_template_directory() .'/functions/post-video.php' );

	// Outputs the post format audio
	require_once( get_template_directory() .'/functions/post-audio.php' );

	// Returns the post format icon
	require_once( get_template_directory() .'/functions/post-format-icon.php' );

	// Image resizing script
	require_once( get_template_directory() .'/functions/image-resizer.php' );

	// Pagination output
	require_once( get_template_directory() .'/functions/pagination.php' );

	// Exclude Posts
	require_once( get_template_directory() .'/functions/exclude-posts.php' );

	// Ads
	require_once( get_template_directory() .'/functions/ads.php' );

}

/*-----------------------------------------------------------------------------------*/
/*	- Include functions for back & front-end
/*-----------------------------------------------------------------------------------*/

// Define widget areas
require_once( get_template_directory() .'/functions/widgets/widget-areas.php' );

// Flickr widget
require_once( get_template_directory() .'/functions/widgets/widget-flickr.php' );

// Social links widget
require_once( get_template_directory() .'/functions/widgets/widget-social.php' );

// Video widget
require_once( get_template_directory() .'/functions/widgets/widget-video.php' );

// Recent posts widget
require_once( get_template_directory() .'/functions/widgets/widget-posts-thumbnails.php' );

// Slider widget
require_once( get_template_directory() .'/functions/widgets/widget-slider.php' );

// Tabs widget
require_once( get_template_directory() .'/functions/widgets/widget-tabs.php' );

// Recent comments with avatars
require_once( get_template_directory() .'/functions/widgets/widget-comments-avatar.php' );

// Recent posts with icons widget
require_once( get_template_directory() .'/functions/widgets/widget-posts-icons.php' );

// Recent News widget
require_once( get_template_directory() .'/functions/widgets/widget-recent-news.php' );

// Default meta options usage
require_once( get_template_directory() .'/functions/user-meta.php' );