<?php
/**
 * The default template for displaying post content.
 *
 * @package WordPress
 * @subpackage Spartan WPExplorer Theme
 * @since Spartan 1.0
 */

// Exit if accessed directly
if ( ! defined( 'ABSPATH' ) ) {
	exit;
} ?>

<?php
// Display post thumbnail
if ( has_post_thumbnail() && $wpex_img = wpex_image( 'array', '', true ) ) { ?>
	<div class="related-carousel-slide">
		<a href="<?php the_permalink(); ?>" title="<?php echo esc_attr( the_title_attribute( 'echo=0' ) ); ?>">
			<img src="<?php echo $wpex_img['url']; ?>" alt="<?php echo esc_attr( the_title_attribute( 'echo=0' ) ); ?>" width="<?php echo $wpex_img['width']; ?>" height="<?php echo $wpex_img['height']; ?>" />
			<?php the_title(); ?>
		</a>
	</div><!-- .related-carousel-slide -->
<?php } ?>