<?php
/**
 * The default template for displaying gallery post formats.
 *
 * @package WordPress
 * @subpackage Spartan WPExplorer Theme
 * @since Spartan 1.0
 */

// Exit if accessed directly
if ( ! defined( 'ABSPATH' ) ) {
	exit;
}

// Get custom query
global $wpex_query;

// Single Post content
if ( is_singular() && !$wpex_query ) { ?>

	<?php
	// Display Gallery = see functions/post-gallery.php
	if ( wpex_gallery_attachments() ) {
		wpex_post_gallery();
	}
	// Featured image fallback
	else {
		wpex_post_featured_image();
	} ?>

<?php }

// Entry content
else { ?>

	<article id="post-<?php the_ID(); ?>" <?php post_class(); ?>>
		<div class="loop-entry-inner clr">
			<?php
			// Display post thumbnail
			if ( has_post_thumbnail() && get_theme_mod( 'wpex_blog_entry_thumb', '1' ) == '1' ) { ?>
				<div class="loop-entry-media clr">
					<?php
					// Cateogory tag
					wpex_category_tag(); ?>
					<figure class="loop-entry-thumbnail">
						<?php if ( get_theme_mod( 'wpex_entry_img_lightbox' ) ) { ?>
						<a href="<?php echo wp_get_attachment_url( get_post_thumbnail_id() ); ?>" title="<?php echo esc_attr( the_title_attribute( 'echo=0' ) ); ?>" class="wpex-lightbox">
						<?php } else { ?>
						<a href="<?php the_permalink(); ?>" title="<?php echo esc_attr( the_title_attribute( 'echo=0' ) ); ?>">
						<?php } ?>
							<?php wpex_entry_featured_image(); ?>
						</a>
					</figure><!-- .loop-entry-thumbnail -->
				</div><!-- .loop-entry-media -->
			<?php } ?>
			<div class="loop-entry-content clr">
				<header>
					<h2 class="loop-entry-title">
						<a href="<?php the_permalink(); ?>" title="<?php echo esc_attr( the_title_attribute( 'echo=0' ) ); ?>"><?php the_title(); ?></a>
					</h2>
					<?php
					// Display post meta details
					wpex_post_meta() ;?>
				</header>
				<div class="loop-entry-excerpt entry clr">
					<?php if ( get_theme_mod( 'wpex_entry_content_excerpt','excerpt' ) == 'content' ) {
						the_content();
					} else {
						wpex_excerpt();
					} ?>
				</div><!-- .loop-entry-excerpt -->
			</div><!-- .loop-entry-content -->
		</div><!-- .loop-entry-inner -->
	</article><!-- .loop-entry -->

<?php } ?>