<?php
/**
 * Used to display a featured category slider
 *
 * @package		WordPress
 * @subpackage	Spartan WPExplorer Theme
 * @since		Spartan 1.0
 */

// Exit if accessed directly
if ( ! defined( 'ABSPATH' ) ) {
	exit;
}

// Get slider content
$wpex_slider_content = get_theme_mod( 'wpex_homepage_slider_content', 'recent_posts' );

// Show homepage featured slider if theme panel category isn't blank
if( $wpex_slider_content && 'none' != $wpex_slider_content && get_theme_mod( 'wpex_homepage_slider_count', '3' ) >= 1 ) :

	if ( 'recent_posts' != $wpex_slider_content ) {
		$wpex_tax_query = array (
			array (
				'taxonomy'	=> 'category',
				'field'		=> 'ID',
				'terms'		=> $wpex_slider_content,
			),
		);
	} else {
		$wpex_tax_query = NULL;
	}
		
	// Get posts based on featured category
	$wpex_query = new WP_Query( array(
		'post_type'				=>'post',
		'posts_per_page'		=> get_theme_mod( 'wpex_homepage_slider_count', '3' ),
		'no_found_rows'			=> true,
		'meta_key'				=> '_thumbnail_id',
		'tax_query'				=> $wpex_tax_query,
		'ignore_sticky_posts'	=> true,
	) );
	
	if( $wpex_query->have_posts() ) { ?>
		<div id="home-slider-wrap" class="clr">
			<div id="home-slider" class="owl-carousel">
				<?php
				$wpex_count='0';
				// Loop through each post
				while( $wpex_query->have_posts() ) : $wpex_query->the_post();
				$wpex_count++;
					if( has_post_thumbnail() ) {
						$img_width = get_theme_mod( 'wpex_home_slider_img_width', '620' );
						$img_height = get_theme_mod( 'wpex_home_slider_img_height', '350' );
						$img_crop = ( '9999' == $img_height ) ? false : true; ?>
						<div class="home-slider-slide" data-dot="<?php echo $wpex_count; ?>">
							<?php
							// Display category ID
							$wpex_category = get_the_category();
							if ( 'recent_posts' != $wpex_slider_content && isset( $wpex_category[0] ) ) {
								if( $wpex_category[0]->term_id == $wpex_slider_content && isset( $wpex_category[1] ) ) {
									$wpex_cat_tag_id = $wpex_category[1]->term_id;
								} else {
									$wpex_cat_tag_id = '';
								}
							} else {
								$wpex_cat_tag_id = '';
							}
							wpex_category_tag( $wpex_cat_tag_id ); ?>
							<div class="home-slider-media">
								<a href="<?php the_permalink(); ?>" title="<?php echo esc_attr( the_title_attribute( 'echo=0' ) ); ?>">
									<img src="<?php echo wpex_img_resize( wp_get_attachment_url( get_post_thumbnail_id() ), $img_width, $img_height, $img_crop ); ?>" alt="<?php echo the_title(); ?>" />
								</a>
							</div><!-- .home-slider-media -->
							<div class="home-slider-caption clr">
								<h2 class="home-slider-caption-title">
									<a href="<?php the_permalink(); ?>" title="<?php echo esc_attr( the_title_attribute( 'echo=0' ) ); ?>" rel="bookmark"><?php the_title(); ?></a>
								</h2>
								<div class="home-slider-caption-excerpt clr">
									<?php echo wp_trim_words( get_the_content(), '25', '&hellip;' ); ?>
								</div><!-- .home-slider-caption-excerpt -->
							</div><!--.home-slider-caption -->
						</div><!-- .home-slider-slide-->
					<?php }
				endwhile; ?>
			</div><!-- #home-slider -->
			<div id="home-slider-numbers"></div>
		</div><!-- #home-slider-wrap -->
	<?php } //End $wpex_query->have_posts check
	// Reset post data to prevent query issues
	wp_reset_postdata();
endif;