<?php
/**
 * The default template for displaying audio post format content.
 *
 * @package WordPress
 * @subpackage Spartan WPExplorer Theme
 * @since Spartan 1.0
 */

// Exit if accessed directly
if ( ! defined( 'ABSPATH' ) ) {
	exit;
}


// Get custom query
global $wpex_query;

// Single Post content
global $wpex_query;


if ( is_singular() && !$wpex_query ) {

	// Display post featured image
	// See functions/post-featured-image.php
	wpex_post_featured_image();

	// Display post audio
	// See functions/commons.php
	wpex_post_audio();

}

// Entry content
else { ?>

	<article id="post-<?php the_ID(); ?>" <?php post_class(); ?>>
		<div class="loop-entry-inner clr">
			<?php
			// Display post thumbnail
			if ( has_post_thumbnail() && get_theme_mod( 'wpex_blog_entry_thumb', '1' ) ) { ?>
				<div class="loop-entry-media clr">
					<?php
					// Cateogory tag
					wpex_category_tag(); ?>
					<figure class="loop-entry-thumbnail">
						<a href="<?php the_permalink(); ?>" title="<?php echo esc_attr( the_title_attribute( 'echo=0' ) ); ?>">
							<?php wpex_entry_featured_image(); ?>
							<span class="loop-entry-audio-overlay"></span>
							<span class="overlay"></span>
						</a>
					</figure><!-- .post-entry-thumbnail -->
				</div><!-- .loop-entry-media -->
			<?php } ?>
			<?php
			// Display post audio
			// See functions/commons.php
			wpex_post_audio(); ?>
			<div class="loop-entry-content clr">
				<header>
					<h2 class="loop-entry-title"><a href="<?php the_permalink(); ?>" title="<?php echo esc_attr( the_title_attribute( 'echo=0' ) ); ?>"><?php the_title(); ?></a></h2>
					<?php
					// Display post meta details
					wpex_post_meta() ;?>
				</header>
				<div class="loop-entry-excerpt entry clr">
					<?php if ( get_theme_mod( 'wpex_entry_content_excerpt','excerpt' ) == 'content' ) {
						the_content();
					} else {
						wpex_excerpt();
					} ?>
				</div><!-- .loop-entry-excerpt -->
			</div><!-- .loop-entry-content -->
		</div><!-- .loop-entry-inner -->
	</article><!-- .loop-entry -->

<?php } ?>