<?php
/**
 * The template for displaying Author archive pages.
 *
 * Learn more: http://codex.wordpress.org/Template_Hierarchy
 *
 * @package WordPress
 * @subpackage Spartan WPExplorer Theme
 * @since Spartan 1.0
 */

get_header(); ?>

	<div id="primary" class="content-area clr">
		<div id="content" class="site-content left-content clr" role="main">
			<?php if ( have_posts() ) : the_post(); ?>
				<header class="archive-header clr">
					<div class="author-archive-gravatar clr">
						<?php echo get_avatar( get_the_author_meta('user_email'), '60'); ?>
					</div>
					<h1 class="archive-header-title"><?php _e( 'Articles Written By', 'wpex' ); ?>: <?php echo get_the_author() ?></h1>
					<div class="archive-description clr">
						<?php
						// Display post count
						$wpex_post_count = count_user_posts( get_query_var( 'author' ) );
						if ( '1' == $wpex_post_count ) {
							_e( 'This author has written 1 article', 'wpex' );
						} else {
							echo sprintf( __( 'This author has written %s articles', 'wpex' ), $wpex_post_count );
						} ?>
					</div><!-- #archive-description -->
					<?php
					// Display grid toggle, see functions/categories.php
					wpex_grid_toggle(); ?>
				</header><!-- .archive-header -->
				<?php rewind_posts(); ?>
				<div id="blog-wrap" class="clr">
					<?php if ( term_description() ) { ?>
						<div class="archive-description clr">
							<?php echo term_description(); ?>
						</div><!-- #archive-description -->
					<?php }
					if( ! is_paged() ) {
						$wpex_count='-1';
					} else {
						$wpex_count='0';
					}
					// The loop
					while ( have_posts() ) : the_post();
					$wpex_count++;
						// First post
						if( '0' == $wpex_count && has_post_thumbnail() && get_theme_mod( 'wpex_archive_feature_first_post', '1' ) && !is_paged() ) { ?>
							<article class="archive-featured-post clr">
								<div class="archive-featured-post-media clr">
									<figure class="archive-featured-post-thumbnail">
										<?php
										// Cateogory tag
										wpex_category_tag( get_query_var( 'cat' ), true ); ?>
										<a href="<?php the_permalink(); ?>" title="<?php echo esc_attr( the_title_attribute( 'echo=0' ) ); ?>">
											<?php wpex_entry_featured_image(); ?>
										</a>
									</figure><!-- .archive-featured-post-thumbnail -->
								</div><!-- .archive-featured-post-media -->
								<div class="archive-featured-post-content clr">
									<header>
										<h2 class="archive-featured-post-title">
											<a href="<?php the_permalink(); ?>" title="<?php echo esc_attr( the_title_attribute( 'echo=0' ) ); ?>"><?php the_title(); ?></a>
										</h2>
									</header>
									<div class="archive-featured-post-excerpt clr">
										<?php echo wp_trim_words( get_the_content(), '25', '&hellip;' ); ?>
									</div><!-- .archive-featured-post-excerpt -->
								</div><!-- .archive-featured-post-content -->
							</article><!-- .archive-featured-post -->
						<?php }
						// All other posts
						else {
							if( '0' == $wpex_count ) {
								$wpex_count = '1';
							}
							get_template_part( 'content', get_post_format() );
						}
						if( '2' == $wpex_count ) {
							$wpex_count = '0';
						}
					endwhile; ?>
				</div><!-- #blog-wrap -->
				<?php wpex_get_pagination(); ?>
			<?php else : ?>
				<?php get_template_part( 'content', 'none' ); ?>
			<?php endif;
			// Content bottom ad
			wpex_ad_spot( 'archive-bottom' ); ?>
		</div><!-- #content -->
		<?php get_sidebar(); ?>
	</div><!-- #primary -->

<?php get_footer(); ?>