<?php

if ( class_exists( 'ICWP_WPSF_FeatureHandler_Autoupdates' ) ) {
	return;
}

require_once( dirname( __FILE__ ).'/base_wpsf.php' );

class ICWP_WPSF_FeatureHandler_Autoupdates extends ICWP_WPSF_FeatureHandler_BaseWpsf {

	protected function doPostConstruction() {
		// Force run automatic updates
		if ( $this->loadDP()->query( 'force_run_auto_updates' ) == 'now' ) {
			add_filter( $this->prefix( 'force_autoupdate' ), '__return_true' );
		}
	}

	/**
	 * @return string[]
	 */
	public function getAutoupdatePlugins() {
		$aSelected = array();
		if ( $this->isAutoupdateIndividualPlugins() ) {
			$aSelected = $this->getOpt( 'selected_plugins', array() );
			if ( !is_array( $aSelected ) ) {
				$aSelected = array();
			}
		}
		return $aSelected;
	}

	/**
	 * @return array
	 */
	public function getDelayTracking() {
		$aTracking = $this->getOpt( 'delay_tracking', array() );
		if ( !is_array( $aTracking ) ) {
			$aTracking = array();
		}
		$aTracking = $this->loadDP()->mergeArraysRecursive(
			array(
				'core'    => array(),
				'plugins' => array(),
				'themes'  => array(),
			),
			$aTracking
		);
		$this->setOpt( 'delay_tracking', $aTracking );

		return $aTracking;
	}

	/**
	 * @return int
	 */
	public function getDelayUpdatesPeriod() {
		return $this->isPremium() ? $this->getOpt( 'update_delay', 0 )*DAY_IN_SECONDS : 0;
	}

	/**
	 * @param array $aTrackingInfo
	 * @return $this
	 */
	public function setDelayTracking( $aTrackingInfo ) {
		return $this->setOpt( 'delay_tracking', $aTrackingInfo );
	}

	/**
	 * @return bool
	 */
	public function isAutoupdateAllPlugins() {
		return $this->isOpt( 'enable_autoupdate_plugins', 'Y' );
	}

	/**
	 * @premium
	 * @return bool
	 */
	public function isAutoupdateIndividualPlugins() {
		return $this->isOpt( 'enable_individual_autoupdate_plugins', 'Y' );
	}

	/**
	 * @return bool
	 */
	public function isDelayUpdates() {
		return $this->getDelayUpdatesPeriod() > 0;
	}

	/**
	 * @param $sPluginFile
	 * @return bool
	 */
	public function isPluginSetToAutoupdate( $sPluginFile ) {
		return in_array( $sPluginFile, $this->getAutoupdatePlugins() );
	}

	/**
	 * @return bool
	 */
	public function isSendAutoupdatesNotificationEmail() {
		return $this->isOpt( 'enable_upgrade_notification_email', 'Y' );
	}

	/**
	 * @param array $aAjaxResponse
	 * @return array
	 */
	public function handleAuthAjax( $aAjaxResponse ) {

		if ( empty( $aAjaxResponse ) ) {
			switch ( $this->loadDP()->request( 'exec' ) ) {

				case 'toggle_plugin_autoupdate':
					if ( $this->isAutoupdateIndividualPlugins() && $this->getConn()->isValidAdminArea() ) {
						$aAjaxResponse = $this->ajaxExec_TogglePluginAutoupdate();
					}
					break;

				default:
					break;
			}
		}
		return parent::handleAuthAjax( $aAjaxResponse );
	}

	/**
	 * @return array
	 */
	public function ajaxExec_TogglePluginAutoupdate() {

		$bSuccess = false;

		$oWpPlugins = $this->loadWpPlugins();
		$sFile = $this->loadDP()->post( 'pluginfile' );
		if ( $oWpPlugins->isInstalled( $sFile ) ) {
			$this->setPluginToAutoUpdate( $sFile );

			$aPlugin = $oWpPlugins->getPlugin( $sFile );
			$sMessage = sprintf( _wpsf__( 'Plugin "%s" will %s.' ),
				$aPlugin[ 'Name' ],
				$this->loadWp()
					 ->getIsPluginAutomaticallyUpdated( $sFile ) ? _wpsf__( 'update automatically' ) : _wpsf__( 'not update automatically' )
			);
			$bSuccess = true;
		}
		else {
			$sMessage = _wpsf__( 'Failed to change the update status of the plugin.' );
		}

		return array(
			'success' => $bSuccess,
			'message' => $sMessage,
		);
	}

	/**
	 * @param string $sPluginFile
	 * @return $this
	 */
	protected function setPluginToAutoUpdate( $sPluginFile ) {
		$aPlugins = $this->getAutoupdatePlugins();
		$nKey = array_search( $sPluginFile, $aPlugins );

		if ( $nKey === false ) {
			$aPlugins[] = $sPluginFile;
		}
		else {
			unset( $aPlugins[ $nKey ] );
		}

		return $this->setOpt( 'selected_plugins', $aPlugins );
	}

	/**
	 * @param array $aOptionsParams
	 * @return array
	 * @throws Exception
	 */
	protected function loadStrings_SectionTitles( $aOptionsParams ) {

		$sSectionSlug = $aOptionsParams[ 'slug' ];
		switch ( $sSectionSlug ) {

			case 'section_enable_plugin_feature_automatic_updates_control' :
				$sTitle = sprintf( _wpsf__( 'Enable Module: %s' ), $this->getMainFeatureName() );
				$aSummary = array(
					sprintf( '%s - %s', _wpsf__( 'Purpose' ), _wpsf__( 'Automatic Updates lets you manage the WordPress automatic updates engine so you choose what exactly gets updated automatically.' ) ),
					sprintf( '%s - %s', _wpsf__( 'Recommendation' ), sprintf( _wpsf__( 'Keep the %s feature turned on.' ), _wpsf__( 'Automatic Updates' ) ) )
				);
				$sTitleShort = sprintf( _wpsf__( '%s/%s Module' ), _wpsf__( 'Enable' ), _wpsf__( 'Disable' ) );
				break;

			case 'section_disable_all_wordpress_automatic_updates' :
				$sTitle = _wpsf__( 'Disable ALL WordPress Automatic Updates' );
				$aSummary = array(
					sprintf( '%s - %s', _wpsf__( 'Purpose' ), _wpsf__( 'If you never want WordPress to automatically update anything on your site, turn on this option.' ) ),
					sprintf( '%s - %s', _wpsf__( 'Recommendation' ), _wpsf__( 'Do not turn on this option unless you really need to block updates.' ) )
				);
				$sTitleShort = _wpsf__( 'Turn Off' );
				break;

			case 'section_automatic_plugin_self_update' :
				$sTitle = _wpsf__( 'Automatic Plugin Self-Update' );
				$aSummary = array(
					sprintf( '%s - %s', _wpsf__( 'Purpose' ), sprintf( _wpsf__( 'Allows the %s plugin to automatically update itself when an update is available.' ), self::getConn()
																																									->getHumanName() ) ),
					sprintf( '%s - %s', _wpsf__( 'Recommendation' ), _wpsf__( 'Keep this option turned on.' ) )
				);
				$sTitleShort = _wpsf__( 'Self-Update' );
				break;

			case 'section_automatic_updates_for_wordpress_components' :
				$sTitle = _wpsf__( 'Automatic Updates For WordPress Components' );
				$aSummary = array(
					sprintf( '%s - %s', _wpsf__( 'Purpose' ), _wpsf__( 'Control how automatic updates for each WordPress component is handled.' ) ),
					sprintf( '%s - %s', _wpsf__( 'Recommendation' ), _wpsf__( 'You should at least allow minor updates for the WordPress core.' ) )
				);
				$sTitleShort = _wpsf__( 'WordPress Components' );
				break;

			case 'section_options' :
				$sTitle = _wpsf__( 'Auto-Update Options' );
				$sTitleShort = _wpsf__( 'Auto-Update Options' );
				$aSummary = array(
					sprintf( '%s - %s', _wpsf__( 'Purpose' ), _wpsf__( 'Make adjustments to how automatic updates are handled on your site.' ) ),
				);
				break;

			default:
				throw new Exception( sprintf( 'A section slug was defined but with no associated strings. Slug: "%s".', $sSectionSlug ) );
		}
		$aOptionsParams[ 'title' ] = $sTitle;
		$aOptionsParams[ 'summary' ] = ( isset( $aSummary ) && is_array( $aSummary ) ) ? $aSummary : array();
		$aOptionsParams[ 'title_short' ] = $sTitleShort;
		return $aOptionsParams;
	}

	/**
	 * @param array $aOptionsParams
	 * @return array
	 * @throws Exception
	 */
	protected function loadStrings_Options( $aOptionsParams ) {

		$sKey = $aOptionsParams[ 'key' ];
		$sPlugName = $this->getConn()->getHumanName();
		switch ( $sKey ) {

			case 'enable_autoupdates' :
				$sName = sprintf( _wpsf__( 'Enable %s Module' ), $this->getMainFeatureName() );
				$sSummary = sprintf( _wpsf__( 'Enable (or Disable) The %s Module' ), $this->getMainFeatureName() );
				$sDescription = sprintf( _wpsf__( 'Un-Checking this option will completely disable the %s module.' ), $this->getMainFeatureName() );
				break;

			case 'enable_autoupdate_disable_all' :
				$sName = _wpsf__( 'Disable All' );
				$sSummary = _wpsf__( 'Completely Disable WordPress Automatic Updates' );
				$sDescription = _wpsf__( 'When selected, regardless of any other settings, all WordPress automatic updates on this site will be completely disabled!' );
				break;

			case 'autoupdate_plugin_self' :
				$sName = _wpsf__( 'Auto Update Plugin' );
				$sSummary = _wpsf__( 'Always Automatically Update This Plugin' );
				$sDescription = sprintf( _wpsf__( 'Regardless of any component settings below, automatically update the "%s" plugin.' ), self::getConn()
																																			 ->getHumanName() );
				break;

			case 'autoupdate_core' :
				$sName = _wpsf__( 'WordPress Core Updates' );
				$sSummary = _wpsf__( 'Decide how the WordPress Core will automatically update, if at all' );
				$sDescription = _wpsf__( 'At least automatically upgrading minor versions is recommended (and is the WordPress default).' );
				break;

			case 'enable_autoupdate_translations' :
				$sName = _wpsf__( 'Translations' );
				$sSummary = _wpsf__( 'Automatically Update Translations' );
				$sDescription = _wpsf__( 'Note: Automatic updates for translations are enabled on WordPress by default.' );
				break;

			case 'enable_autoupdate_plugins' :
				$sName = _wpsf__( 'Plugins' );
				$sSummary = _wpsf__( 'Automatically Update All Plugins' );
				$sDescription = _wpsf__( 'Note: Automatic updates for plugins are disabled on WordPress by default.' );
				break;

			case 'enable_individual_autoupdate_plugins' :
				$sName = _wpsf__( 'Individually Select Plugins' );
				$sSummary = _wpsf__( 'Select Individual Plugins To Automatically Update' );
				$sDescription = _wpsf__( 'Turning this on will provide an option on the plugins page to select whether a plugin is automatically updated.' );
				break;

			case 'enable_autoupdate_themes' :
				$sName = _wpsf__( 'Themes' );
				$sSummary = _wpsf__( 'Automatically Update Themes' );
				$sDescription = _wpsf__( 'Note: Automatic updates for themes are disabled on WordPress by default.' );
				break;

			case 'enable_autoupdate_ignore_vcs' :
				$sName = _wpsf__( 'Ignore Version Control' );
				$sSummary = _wpsf__( 'Ignore Version Control Systems Such As GIT and SVN' );
				$sDescription = _wpsf__( 'If you use SVN or GIT and WordPress detects it, automatic updates are disabled by default. Check this box to ignore version control systems and allow automatic updates.' );
				break;

			case 'enable_upgrade_notification_email' :
				$sName = _wpsf__( 'Send Report Email' );
				$sSummary = _wpsf__( 'Send email notices after automatic updates' );
				$sDescription = _wpsf__( 'You can turn on/off email notices from automatic updates by un/checking this box.' );
				break;

			case 'override_email_address' :
				$sName = _wpsf__( 'Report Email Address' );
				$sSummary = _wpsf__( 'Where to send upgrade notification reports' );
				$sDescription = _wpsf__( 'If this is empty, it will default to the Site Admin email address' );
				break;

			case 'update_delay' :
				$sName = _wpsf__( 'Update Delay' );
				$sSummary = _wpsf__( 'Delay Automatic Updates For Period Of Stability' );
				$sDescription = sprintf( _wpsf__( '%s will delay upgrades until the new update has been available for the set number of days.' ), $sPlugName )
								.'<br />'._wpsf__( "This helps ensure updates are more stable before they're automatically applied to your site." );
				break;

			default:
				throw new Exception( sprintf( 'An option has been defined but without strings assigned to it. Option key: "%s".', $sKey ) );
		}

		$aOptionsParams[ 'name' ] = $sName;
		$aOptionsParams[ 'summary' ] = $sSummary;
		$aOptionsParams[ 'description' ] = $sDescription;
		return $aOptionsParams;
	}
}